/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdate;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceUpdatesResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeServiceUpdatesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeServiceUpdatesResponse.getter(DescribeServiceUpdatesResponse::marker)).setter(DescribeServiceUpdatesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ServiceUpdate>> SERVICE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceUpdates").getter(DescribeServiceUpdatesResponse.getter(DescribeServiceUpdatesResponse::serviceUpdates)).setter(DescribeServiceUpdatesResponse.setter(Builder::serviceUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdates").build(), ListTrait.builder().memberLocationName("ServiceUpdate").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdate").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, SERVICE_UPDATES_FIELD));
    private final String marker;
    private final List<ServiceUpdate> serviceUpdates;

    private DescribeServiceUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.serviceUpdates = builder.serviceUpdates;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasServiceUpdates() {
        return this.serviceUpdates != null && !(this.serviceUpdates instanceof SdkAutoConstructList);
    }

    public final List<ServiceUpdate> serviceUpdates() {
        return this.serviceUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceUpdates() ? this.serviceUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceUpdatesResponse)) {
            return false;
        }
        DescribeServiceUpdatesResponse other = (DescribeServiceUpdatesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasServiceUpdates() == other.hasServiceUpdates() && Objects.equals(this.serviceUpdates(), other.serviceUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceUpdatesResponse").add("Marker", (Object)this.marker()).add("ServiceUpdates", this.hasServiceUpdates() ? this.serviceUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ServiceUpdates": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceUpdatesResponse, T> g) {
        return obj -> g.apply((DescribeServiceUpdatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ServiceUpdate> serviceUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceUpdatesResponse model) {
            super(model);
            this.marker(model.marker);
            this.serviceUpdates(model.serviceUpdates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ServiceUpdate.Builder> getServiceUpdates() {
            if (this.serviceUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceUpdates != null ? (Collection)this.serviceUpdates.stream().map(ServiceUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceUpdates(Collection<ServiceUpdate> serviceUpdates) {
            this.serviceUpdates = ServiceUpdateListCopier.copy(serviceUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdates(ServiceUpdate ... serviceUpdates) {
            this.serviceUpdates(Arrays.asList(serviceUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdates(Consumer<ServiceUpdate.Builder> ... serviceUpdates) {
            this.serviceUpdates(Stream.of(serviceUpdates).map(c -> (ServiceUpdate)((ServiceUpdate.Builder)ServiceUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceUpdates(Collection<ServiceUpdate.BuilderImpl> serviceUpdates) {
            this.serviceUpdates = ServiceUpdateListCopier.copyFromBuilder(serviceUpdates);
        }

        @Override
        public DescribeServiceUpdatesResponse build() {
            return new DescribeServiceUpdatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceUpdatesResponse> {
        public Builder marker(String var1);

        public Builder serviceUpdates(Collection<ServiceUpdate> var1);

        public Builder serviceUpdates(ServiceUpdate ... var1);

        public Builder serviceUpdates(Consumer<ServiceUpdate.Builder> ... var1);
    }
}

