/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceType {
    CACHE_CLUSTER("cache-cluster"),
    CACHE_PARAMETER_GROUP("cache-parameter-group"),
    CACHE_SECURITY_GROUP("cache-security-group"),
    CACHE_SUBNET_GROUP("cache-subnet-group"),
    REPLICATION_GROUP("replication-group"),
    USER("user"),
    USER_GROUP("user-group"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceType> knownValues() {
        return Stream.of(SourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

