/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.UserGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserGroupsUpdateStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserGroupsUpdateStatus> {
    private static final SdkField<List<String>> USER_GROUP_IDS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserGroupIdsToAdd").getter(UserGroupsUpdateStatus.getter(UserGroupsUpdateStatus::userGroupIdsToAdd)).setter(UserGroupsUpdateStatus.setter(Builder::userGroupIdsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIdsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_GROUP_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserGroupIdsToRemove").getter(UserGroupsUpdateStatus.getter(UserGroupsUpdateStatus::userGroupIdsToRemove)).setter(UserGroupsUpdateStatus.setter(Builder::userGroupIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIdsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUP_IDS_TO_ADD_FIELD, USER_GROUP_IDS_TO_REMOVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> userGroupIdsToAdd;
    private final List<String> userGroupIdsToRemove;

    private UserGroupsUpdateStatus(BuilderImpl builder) {
        this.userGroupIdsToAdd = builder.userGroupIdsToAdd;
        this.userGroupIdsToRemove = builder.userGroupIdsToRemove;
    }

    public boolean hasUserGroupIdsToAdd() {
        return this.userGroupIdsToAdd != null && !(this.userGroupIdsToAdd instanceof SdkAutoConstructList);
    }

    public List<String> userGroupIdsToAdd() {
        return this.userGroupIdsToAdd;
    }

    public boolean hasUserGroupIdsToRemove() {
        return this.userGroupIdsToRemove != null && !(this.userGroupIdsToRemove instanceof SdkAutoConstructList);
    }

    public List<String> userGroupIdsToRemove() {
        return this.userGroupIdsToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroupIdsToAdd() ? this.userGroupIdsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroupIdsToRemove() ? this.userGroupIdsToRemove() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserGroupsUpdateStatus)) {
            return false;
        }
        UserGroupsUpdateStatus other = (UserGroupsUpdateStatus)obj;
        return this.hasUserGroupIdsToAdd() == other.hasUserGroupIdsToAdd() && Objects.equals(this.userGroupIdsToAdd(), other.userGroupIdsToAdd()) && this.hasUserGroupIdsToRemove() == other.hasUserGroupIdsToRemove() && Objects.equals(this.userGroupIdsToRemove(), other.userGroupIdsToRemove());
    }

    public String toString() {
        return ToString.builder((String)"UserGroupsUpdateStatus").add("UserGroupIdsToAdd", this.hasUserGroupIdsToAdd() ? this.userGroupIdsToAdd() : null).add("UserGroupIdsToRemove", this.hasUserGroupIdsToRemove() ? this.userGroupIdsToRemove() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserGroupIdsToAdd": {
                return Optional.ofNullable(clazz.cast(this.userGroupIdsToAdd()));
            }
            case "UserGroupIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.userGroupIdsToRemove()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserGroupsUpdateStatus, T> g) {
        return obj -> g.apply((UserGroupsUpdateStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> userGroupIdsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> userGroupIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserGroupsUpdateStatus model) {
            this.userGroupIdsToAdd(model.userGroupIdsToAdd);
            this.userGroupIdsToRemove(model.userGroupIdsToRemove);
        }

        public final Collection<String> getUserGroupIdsToAdd() {
            if (this.userGroupIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroupIdsToAdd;
        }

        @Override
        public final Builder userGroupIdsToAdd(Collection<String> userGroupIdsToAdd) {
            this.userGroupIdsToAdd = UserGroupIdListCopier.copy(userGroupIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIdsToAdd(String ... userGroupIdsToAdd) {
            this.userGroupIdsToAdd(Arrays.asList(userGroupIdsToAdd));
            return this;
        }

        public final void setUserGroupIdsToAdd(Collection<String> userGroupIdsToAdd) {
            this.userGroupIdsToAdd = UserGroupIdListCopier.copy(userGroupIdsToAdd);
        }

        public final Collection<String> getUserGroupIdsToRemove() {
            if (this.userGroupIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroupIdsToRemove;
        }

        @Override
        public final Builder userGroupIdsToRemove(Collection<String> userGroupIdsToRemove) {
            this.userGroupIdsToRemove = UserGroupIdListCopier.copy(userGroupIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIdsToRemove(String ... userGroupIdsToRemove) {
            this.userGroupIdsToRemove(Arrays.asList(userGroupIdsToRemove));
            return this;
        }

        public final void setUserGroupIdsToRemove(Collection<String> userGroupIdsToRemove) {
            this.userGroupIdsToRemove = UserGroupIdListCopier.copy(userGroupIdsToRemove);
        }

        public UserGroupsUpdateStatus build() {
            return new UserGroupsUpdateStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserGroupsUpdateStatus> {
        public Builder userGroupIdsToAdd(Collection<String> var1);

        public Builder userGroupIdsToAdd(String ... var1);

        public Builder userGroupIdsToRemove(Collection<String> var1);

        public Builder userGroupIdsToRemove(String ... var1);
    }
}

