/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.CacheClusterListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCacheClustersResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeCacheClustersResponse.getter(DescribeCacheClustersResponse::marker)).setter(DescribeCacheClustersResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<CacheCluster>> CACHE_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheClusters").getter(DescribeCacheClustersResponse.getter(DescribeCacheClustersResponse::cacheClusters)).setter(DescribeCacheClustersResponse.setter(Builder::cacheClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusters").build(), ListTrait.builder().memberLocationName("CacheCluster").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheCluster").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CACHE_CLUSTERS_FIELD));
    private final String marker;
    private final List<CacheCluster> cacheClusters;

    private DescribeCacheClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheClusters = builder.cacheClusters;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasCacheClusters() {
        return this.cacheClusters != null && !(this.cacheClusters instanceof SdkAutoConstructList);
    }

    public List<CacheCluster> cacheClusters() {
        return this.cacheClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheClusters() ? this.cacheClusters() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersResponse)) {
            return false;
        }
        DescribeCacheClustersResponse other = (DescribeCacheClustersResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasCacheClusters() == other.hasCacheClusters() && Objects.equals(this.cacheClusters(), other.cacheClusters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCacheClustersResponse").add("Marker", (Object)this.marker()).add("CacheClusters", this.hasCacheClusters() ? this.cacheClusters() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "CacheClusters": {
                return Optional.ofNullable(clazz.cast(this.cacheClusters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheClustersResponse, T> g) {
        return obj -> g.apply((DescribeCacheClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheCluster> cacheClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheClustersResponse model) {
            super(model);
            this.marker(model.marker);
            this.cacheClusters(model.cacheClusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheCluster.Builder> getCacheClusters() {
            if (this.cacheClusters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheClusters != null ? (Collection)this.cacheClusters.stream().map(CacheCluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheClusters(Collection<CacheCluster> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copy(cacheClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusters(CacheCluster ... cacheClusters) {
            this.cacheClusters(Arrays.asList(cacheClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusters(Consumer<CacheCluster.Builder> ... cacheClusters) {
            this.cacheClusters(Stream.of(cacheClusters).map(c -> (CacheCluster)((CacheCluster.Builder)CacheCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCacheClusters(Collection<CacheCluster.BuilderImpl> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copyFromBuilder(cacheClusters);
        }

        @Override
        public DescribeCacheClustersResponse build() {
            return new DescribeCacheClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCacheClustersResponse> {
        public Builder marker(String var1);

        public Builder cacheClusters(Collection<CacheCluster> var1);

        public Builder cacheClusters(CacheCluster ... var1);

        public Builder cacheClusters(Consumer<CacheCluster.Builder> ... var1);
    }
}

