/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AZMode;
import software.amazon.awssdk.services.elasticache.model.AuthTokenUpdateStrategyType;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.PreferredAvailabilityZoneListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCacheClusterRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyCacheClusterRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterId").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::cacheClusterId)).setter(ModifyCacheClusterRequest.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumCacheNodes").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::numCacheNodes)).setter(ModifyCacheClusterRequest.setter(Builder::numCacheNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()}).build();
    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheNodeIdsToRemove").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::cacheNodeIdsToRemove)).setter(ModifyCacheClusterRequest.setter(Builder::cacheNodeIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToRemove").build(), ListTrait.builder().memberLocationName("CacheNodeId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()}).build()).build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AZMode").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::azModeAsString)).setter(ModifyCacheClusterRequest.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AZMode").build()}).build();
    private static final SdkField<List<String>> NEW_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NewAvailabilityZones").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::newAvailabilityZones)).setter(ModifyCacheClusterRequest.setter(Builder::newAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewAvailabilityZones").build(), ListTrait.builder().memberLocationName("PreferredAvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheSecurityGroupNames").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::cacheSecurityGroupNames)).setter(ModifyCacheClusterRequest.setter(Builder::cacheSecurityGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(), ListTrait.builder().memberLocationName("CacheSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::securityGroupIds)).setter(ModifyCacheClusterRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::preferredMaintenanceWindow)).setter(ModifyCacheClusterRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationTopicArn").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::notificationTopicArn)).setter(ModifyCacheClusterRequest.setter(Builder::notificationTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build()}).build();
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheParameterGroupName").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::cacheParameterGroupName)).setter(ModifyCacheClusterRequest.setter(Builder::cacheParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build()}).build();
    private static final SdkField<String> NOTIFICATION_TOPIC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationTopicStatus").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::notificationTopicStatus)).setter(ModifyCacheClusterRequest.setter(Builder::notificationTopicStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicStatus").build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyImmediately").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::applyImmediately)).setter(ModifyCacheClusterRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::engineVersion)).setter(ModifyCacheClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::autoMinorVersionUpgrade)).setter(ModifyCacheClusterRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::snapshotRetentionLimit)).setter(ModifyCacheClusterRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::snapshotWindow)).setter(ModifyCacheClusterRequest.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeType").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::cacheNodeType)).setter(ModifyCacheClusterRequest.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthToken").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::authToken)).setter(ModifyCacheClusterRequest.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_UPDATE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthTokenUpdateStrategy").getter(ModifyCacheClusterRequest.getter(ModifyCacheClusterRequest::authTokenUpdateStrategyAsString)).setter(ModifyCacheClusterRequest.setter(Builder::authTokenUpdateStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenUpdateStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD, NUM_CACHE_NODES_FIELD, CACHE_NODE_IDS_TO_REMOVE_FIELD, AZ_MODE_FIELD, NEW_AVAILABILITY_ZONES_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD, NOTIFICATION_TOPIC_STATUS_FIELD, APPLY_IMMEDIATELY_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_FIELD, AUTH_TOKEN_UPDATE_STRATEGY_FIELD));
    private final String cacheClusterId;
    private final Integer numCacheNodes;
    private final List<String> cacheNodeIdsToRemove;
    private final String azMode;
    private final List<String> newAvailabilityZones;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final String preferredMaintenanceWindow;
    private final String notificationTopicArn;
    private final String cacheParameterGroupName;
    private final String notificationTopicStatus;
    private final Boolean applyImmediately;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String cacheNodeType;
    private final String authToken;
    private final String authTokenUpdateStrategy;

    private ModifyCacheClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeIdsToRemove = builder.cacheNodeIdsToRemove;
        this.azMode = builder.azMode;
        this.newAvailabilityZones = builder.newAvailabilityZones;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.applyImmediately = builder.applyImmediately;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.cacheNodeType = builder.cacheNodeType;
        this.authToken = builder.authToken;
        this.authTokenUpdateStrategy = builder.authTokenUpdateStrategy;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public boolean hasCacheNodeIdsToRemove() {
        return this.cacheNodeIdsToRemove != null && !(this.cacheNodeIdsToRemove instanceof SdkAutoConstructList);
    }

    public List<String> cacheNodeIdsToRemove() {
        return this.cacheNodeIdsToRemove;
    }

    public AZMode azMode() {
        return AZMode.fromValue(this.azMode);
    }

    public String azModeAsString() {
        return this.azMode;
    }

    public boolean hasNewAvailabilityZones() {
        return this.newAvailabilityZones != null && !(this.newAvailabilityZones instanceof SdkAutoConstructList);
    }

    public List<String> newAvailabilityZones() {
        return this.newAvailabilityZones;
    }

    public boolean hasCacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames != null && !(this.cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String notificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String authToken() {
        return this.authToken;
    }

    public AuthTokenUpdateStrategyType authTokenUpdateStrategy() {
        return AuthTokenUpdateStrategyType.fromValue(this.authTokenUpdateStrategy);
    }

    public String authTokenUpdateStrategyAsString() {
        return this.authTokenUpdateStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheNodeIdsToRemove() ? this.cacheNodeIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewAvailabilityZones() ? this.newAvailabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheSecurityGroupNames() ? this.cacheSecurityGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenUpdateStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheClusterRequest)) {
            return false;
        }
        ModifyCacheClusterRequest other = (ModifyCacheClusterRequest)((Object)obj);
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.numCacheNodes(), other.numCacheNodes()) && this.hasCacheNodeIdsToRemove() == other.hasCacheNodeIdsToRemove() && Objects.equals(this.cacheNodeIdsToRemove(), other.cacheNodeIdsToRemove()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && this.hasNewAvailabilityZones() == other.hasNewAvailabilityZones() && Objects.equals(this.newAvailabilityZones(), other.newAvailabilityZones()) && this.hasCacheSecurityGroupNames() == other.hasCacheSecurityGroupNames() && Objects.equals(this.cacheSecurityGroupNames(), other.cacheSecurityGroupNames()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.notificationTopicArn(), other.notificationTopicArn()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.notificationTopicStatus(), other.notificationTopicStatus()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.authToken(), other.authToken()) && Objects.equals(this.authTokenUpdateStrategyAsString(), other.authTokenUpdateStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"ModifyCacheClusterRequest").add("CacheClusterId", (Object)this.cacheClusterId()).add("NumCacheNodes", (Object)this.numCacheNodes()).add("CacheNodeIdsToRemove", this.hasCacheNodeIdsToRemove() ? this.cacheNodeIdsToRemove() : null).add("AZMode", (Object)this.azModeAsString()).add("NewAvailabilityZones", this.hasNewAvailabilityZones() ? this.newAvailabilityZones() : null).add("CacheSecurityGroupNames", this.hasCacheSecurityGroupNames() ? this.cacheSecurityGroupNames() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("NotificationTopicArn", (Object)this.notificationTopicArn()).add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("NotificationTopicStatus", (Object)this.notificationTopicStatus()).add("ApplyImmediately", (Object)this.applyImmediately()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("CacheNodeType", (Object)this.cacheNodeType()).add("AuthToken", (Object)this.authToken()).add("AuthTokenUpdateStrategy", (Object)this.authTokenUpdateStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "NumCacheNodes": {
                return Optional.ofNullable(clazz.cast(this.numCacheNodes()));
            }
            case "CacheNodeIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeIdsToRemove()));
            }
            case "AZMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "NewAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.newAvailabilityZones()));
            }
            case "CacheSecurityGroupNames": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroupNames()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "NotificationTopicArn": {
                return Optional.ofNullable(clazz.cast(this.notificationTopicArn()));
            }
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "NotificationTopicStatus": {
                return Optional.ofNullable(clazz.cast(this.notificationTopicStatus()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
            case "AuthTokenUpdateStrategy": {
                return Optional.ofNullable(clazz.cast(this.authTokenUpdateStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCacheClusterRequest, T> g) {
        return obj -> g.apply((ModifyCacheClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private Integer numCacheNodes;
        private List<String> cacheNodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();
        private String azMode;
        private List<String> newAvailabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String preferredMaintenanceWindow;
        private String notificationTopicArn;
        private String cacheParameterGroupName;
        private String notificationTopicStatus;
        private Boolean applyImmediately;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String cacheNodeType;
        private String authToken;
        private String authTokenUpdateStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCacheClusterRequest model) {
            super(model);
            this.cacheClusterId(model.cacheClusterId);
            this.numCacheNodes(model.numCacheNodes);
            this.cacheNodeIdsToRemove(model.cacheNodeIdsToRemove);
            this.azMode(model.azMode);
            this.newAvailabilityZones(model.newAvailabilityZones);
            this.cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.securityGroupIds(model.securityGroupIds);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.notificationTopicArn(model.notificationTopicArn);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.notificationTopicStatus(model.notificationTopicStatus);
            this.applyImmediately(model.applyImmediately);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.cacheNodeType(model.cacheNodeType);
            this.authToken(model.authToken);
            this.authTokenUpdateStrategy(model.authTokenUpdateStrategy);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final Collection<String> getCacheNodeIdsToRemove() {
            if (this.cacheNodeIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheNodeIdsToRemove;
        }

        @Override
        public final Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove(Arrays.asList(cacheNodeIdsToRemove));
            return this;
        }

        public final void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
        }

        public final String getAzMode() {
            return this.azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(AZMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        public final Collection<String> getNewAvailabilityZones() {
            if (this.newAvailabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.newAvailabilityZones;
        }

        @Override
        public final Builder newAvailabilityZones(Collection<String> newAvailabilityZones) {
            this.newAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(newAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newAvailabilityZones(String ... newAvailabilityZones) {
            this.newAvailabilityZones(Arrays.asList(newAvailabilityZones));
            return this;
        }

        public final void setNewAvailabilityZones(Collection<String> newAvailabilityZones) {
            this.newAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(newAvailabilityZones);
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            if (this.cacheSecurityGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getNotificationTopicStatus() {
            return this.notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public final String getAuthTokenUpdateStrategy() {
            return this.authTokenUpdateStrategy;
        }

        @Override
        public final Builder authTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
            return this;
        }

        @Override
        public final Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy(authTokenUpdateStrategy == null ? null : authTokenUpdateStrategy.toString());
            return this;
        }

        public final void setAuthTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCacheClusterRequest build() {
            return new ModifyCacheClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCacheClusterRequest> {
        public Builder cacheClusterId(String var1);

        public Builder numCacheNodes(Integer var1);

        public Builder cacheNodeIdsToRemove(Collection<String> var1);

        public Builder cacheNodeIdsToRemove(String ... var1);

        public Builder azMode(String var1);

        public Builder azMode(AZMode var1);

        public Builder newAvailabilityZones(Collection<String> var1);

        public Builder newAvailabilityZones(String ... var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationTopicArn(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder notificationTopicStatus(String var1);

        public Builder applyImmediately(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder cacheNodeType(String var1);

        public Builder authToken(String var1);

        public Builder authTokenUpdateStrategy(String var1);

        public Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

