/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.AuthTokenUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.ReshardingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationGroupPendingModifiedValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::primaryClusterId)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::primaryClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()}).build();
    private static final SdkField<String> AUTOMATIC_FAILOVER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::automaticFailoverStatusAsString)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::automaticFailoverStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverStatus").build()}).build();
    private static final SdkField<ReshardingStatus> RESHARDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::resharding)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::resharding)).constructor(ReshardingStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resharding").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::authTokenStatusAsString)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::authTokenStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_STATUS_FIELD, RESHARDING_FIELD, AUTH_TOKEN_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String primaryClusterId;
    private final String automaticFailoverStatus;
    private final ReshardingStatus resharding;
    private final String authTokenStatus;

    private ReplicationGroupPendingModifiedValues(BuilderImpl builder) {
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverStatus = builder.automaticFailoverStatus;
        this.resharding = builder.resharding;
        this.authTokenStatus = builder.authTokenStatus;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public PendingAutomaticFailoverStatus automaticFailoverStatus() {
        return PendingAutomaticFailoverStatus.fromValue(this.automaticFailoverStatus);
    }

    public String automaticFailoverStatusAsString() {
        return this.automaticFailoverStatus;
    }

    public ReshardingStatus resharding() {
        return this.resharding;
    }

    public AuthTokenUpdateStatus authTokenStatus() {
        return AuthTokenUpdateStatus.fromValue(this.authTokenStatus);
    }

    public String authTokenStatusAsString() {
        return this.authTokenStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resharding());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupPendingModifiedValues)) {
            return false;
        }
        ReplicationGroupPendingModifiedValues other = (ReplicationGroupPendingModifiedValues)obj;
        return Objects.equals(this.primaryClusterId(), other.primaryClusterId()) && Objects.equals(this.automaticFailoverStatusAsString(), other.automaticFailoverStatusAsString()) && Objects.equals(this.resharding(), other.resharding()) && Objects.equals(this.authTokenStatusAsString(), other.authTokenStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationGroupPendingModifiedValues").add("PrimaryClusterId", (Object)this.primaryClusterId()).add("AutomaticFailoverStatus", (Object)this.automaticFailoverStatusAsString()).add("Resharding", (Object)this.resharding()).add("AuthTokenStatus", (Object)this.authTokenStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryClusterId": {
                return Optional.ofNullable(clazz.cast(this.primaryClusterId()));
            }
            case "AutomaticFailoverStatus": {
                return Optional.ofNullable(clazz.cast(this.automaticFailoverStatusAsString()));
            }
            case "Resharding": {
                return Optional.ofNullable(clazz.cast(this.resharding()));
            }
            case "AuthTokenStatus": {
                return Optional.ofNullable(clazz.cast(this.authTokenStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroupPendingModifiedValues, T> g) {
        return obj -> g.apply((ReplicationGroupPendingModifiedValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryClusterId;
        private String automaticFailoverStatus;
        private ReshardingStatus resharding;
        private String authTokenStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupPendingModifiedValues model) {
            this.primaryClusterId(model.primaryClusterId);
            this.automaticFailoverStatus(model.automaticFailoverStatus);
            this.resharding(model.resharding);
            this.authTokenStatus(model.authTokenStatus);
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final String getAutomaticFailoverStatus() {
            return this.automaticFailoverStatus;
        }

        @Override
        public final Builder automaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
            return this;
        }

        @Override
        public final Builder automaticFailoverStatus(PendingAutomaticFailoverStatus automaticFailoverStatus) {
            this.automaticFailoverStatus(automaticFailoverStatus == null ? null : automaticFailoverStatus.toString());
            return this;
        }

        public final void setAutomaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
        }

        public final ReshardingStatus.Builder getResharding() {
            return this.resharding != null ? this.resharding.toBuilder() : null;
        }

        @Override
        public final Builder resharding(ReshardingStatus resharding) {
            this.resharding = resharding;
            return this;
        }

        public final void setResharding(ReshardingStatus.BuilderImpl resharding) {
            this.resharding = resharding != null ? resharding.build() : null;
        }

        public final String getAuthTokenStatus() {
            return this.authTokenStatus;
        }

        @Override
        public final Builder authTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
            return this;
        }

        @Override
        public final Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus) {
            this.authTokenStatus(authTokenStatus == null ? null : authTokenStatus.toString());
            return this;
        }

        public final void setAuthTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
        }

        public ReplicationGroupPendingModifiedValues build() {
            return new ReplicationGroupPendingModifiedValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
        public Builder primaryClusterId(String var1);

        public Builder automaticFailoverStatus(String var1);

        public Builder automaticFailoverStatus(PendingAutomaticFailoverStatus var1);

        public Builder resharding(ReshardingStatus var1);

        default public Builder resharding(Consumer<ReshardingStatus.Builder> resharding) {
            return this.resharding((ReshardingStatus)((ReshardingStatus.Builder)ReshardingStatus.builder().applyMutation(resharding)).build());
        }

        public Builder authTokenStatus(String var1);

        public Builder authTokenStatus(AuthTokenUpdateStatus var1);
    }
}

