/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.UpdateAction;
import software.amazon.awssdk.services.elasticache.model.UpdateActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUpdateActionsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeUpdateActionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUpdateActionsResponse.getter(DescribeUpdateActionsResponse::marker)).setter(DescribeUpdateActionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<UpdateAction>> UPDATE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeUpdateActionsResponse.getter(DescribeUpdateActionsResponse::updateActions)).setter(DescribeUpdateActionsResponse.setter(Builder::updateActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActions").build(), ListTrait.builder().memberLocationName("UpdateAction").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateAction").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, UPDATE_ACTIONS_FIELD));
    private final String marker;
    private final List<UpdateAction> updateActions;

    private DescribeUpdateActionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.updateActions = builder.updateActions;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasUpdateActions() {
        return this.updateActions != null && !(this.updateActions instanceof SdkAutoConstructList);
    }

    public List<UpdateAction> updateActions() {
        return this.updateActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateActionsResponse)) {
            return false;
        }
        DescribeUpdateActionsResponse other = (DescribeUpdateActionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.updateActions(), other.updateActions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUpdateActionsResponse").add("Marker", (Object)this.marker()).add("UpdateActions", this.updateActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "UpdateActions": {
                return Optional.ofNullable(clazz.cast(this.updateActions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateActionsResponse, T> g) {
        return obj -> g.apply((DescribeUpdateActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<UpdateAction> updateActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateActionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.updateActions(model.updateActions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<UpdateAction.Builder> getUpdateActions() {
            return this.updateActions != null ? (Collection)this.updateActions.stream().map(UpdateAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updateActions(Collection<UpdateAction> updateActions) {
            this.updateActions = UpdateActionListCopier.copy(updateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActions(UpdateAction ... updateActions) {
            this.updateActions(Arrays.asList(updateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActions(Consumer<UpdateAction.Builder> ... updateActions) {
            this.updateActions(Stream.of(updateActions).map(c -> (UpdateAction)((UpdateAction.Builder)UpdateAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdateActions(Collection<UpdateAction.BuilderImpl> updateActions) {
            this.updateActions = UpdateActionListCopier.copyFromBuilder(updateActions);
        }

        @Override
        public DescribeUpdateActionsResponse build() {
            return new DescribeUpdateActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUpdateActionsResponse> {
        public Builder marker(String var1);

        public Builder updateActions(Collection<UpdateAction> var1);

        public Builder updateActions(UpdateAction ... var1);

        public Builder updateActions(Consumer<UpdateAction.Builder> ... var1);
    }
}

