/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroup;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReplicationGroupsResponse.getter(DescribeReplicationGroupsResponse::marker)).setter(DescribeReplicationGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReplicationGroup>> REPLICATION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReplicationGroupsResponse.getter(DescribeReplicationGroupsResponse::replicationGroups)).setter(DescribeReplicationGroupsResponse.setter(Builder::replicationGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroups").build(), ListTrait.builder().memberLocationName("ReplicationGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATION_GROUPS_FIELD));
    private final String marker;
    private final List<ReplicationGroup> replicationGroups;

    private DescribeReplicationGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationGroups = builder.replicationGroups;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasReplicationGroups() {
        return this.replicationGroups != null && !(this.replicationGroups instanceof SdkAutoConstructList);
    }

    public List<ReplicationGroup> replicationGroups() {
        return this.replicationGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationGroupsResponse)) {
            return false;
        }
        DescribeReplicationGroupsResponse other = (DescribeReplicationGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.replicationGroups(), other.replicationGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationGroupsResponse").add("Marker", (Object)this.marker()).add("ReplicationGroups", this.replicationGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationGroups": {
                return Optional.ofNullable(clazz.cast(this.replicationGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationGroupsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationGroup> replicationGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationGroups(model.replicationGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationGroup.Builder> getReplicationGroups() {
            return this.replicationGroups != null ? (Collection)this.replicationGroups.stream().map(ReplicationGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationGroups(Collection<ReplicationGroup> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copy(replicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(ReplicationGroup ... replicationGroups) {
            this.replicationGroups(Arrays.asList(replicationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(Consumer<ReplicationGroup.Builder> ... replicationGroups) {
            this.replicationGroups(Stream.of(replicationGroups).map(c -> (ReplicationGroup)((ReplicationGroup.Builder)ReplicationGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationGroups(Collection<ReplicationGroup.BuilderImpl> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copyFromBuilder(replicationGroups);
        }

        @Override
        public DescribeReplicationGroupsResponse build() {
            return new DescribeReplicationGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
        public Builder marker(String var1);

        public Builder replicationGroups(Collection<ReplicationGroup> var1);

        public Builder replicationGroups(ReplicationGroup ... var1);

        public Builder replicationGroups(Consumer<ReplicationGroup.Builder> ... var1);
    }
}

