/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AuthTokenUpdateStrategyType;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyReplicationGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyReplicationGroupRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::replicationGroupId)).setter(ModifyReplicationGroupRequest.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::replicationGroupDescription)).setter(ModifyReplicationGroupRequest.setter(Builder::replicationGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupDescription").build()}).build();
    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::primaryClusterId)).setter(ModifyReplicationGroupRequest.setter(Builder::primaryClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()}).build();
    private static final SdkField<String> SNAPSHOTTING_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::snapshottingClusterId)).setter(ModifyReplicationGroupRequest.setter(Builder::snapshottingClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshottingClusterId").build()}).build();
    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::automaticFailoverEnabled)).setter(ModifyReplicationGroupRequest.setter(Builder::automaticFailoverEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::multiAZEnabled)).setter(ModifyReplicationGroupRequest.setter(Builder::multiAZEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZEnabled").build()}).build();
    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::nodeGroupId)).setter(ModifyReplicationGroupRequest.setter(Builder::nodeGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()}).build();
    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::cacheSecurityGroupNames)).setter(ModifyReplicationGroupRequest.setter(Builder::cacheSecurityGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(), ListTrait.builder().memberLocationName("CacheSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::securityGroupIds)).setter(ModifyReplicationGroupRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::preferredMaintenanceWindow)).setter(ModifyReplicationGroupRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::notificationTopicArn)).setter(ModifyReplicationGroupRequest.setter(Builder::notificationTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build()}).build();
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::cacheParameterGroupName)).setter(ModifyReplicationGroupRequest.setter(Builder::cacheParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build()}).build();
    private static final SdkField<String> NOTIFICATION_TOPIC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::notificationTopicStatus)).setter(ModifyReplicationGroupRequest.setter(Builder::notificationTopicStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicStatus").build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::applyImmediately)).setter(ModifyReplicationGroupRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::engineVersion)).setter(ModifyReplicationGroupRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::autoMinorVersionUpgrade)).setter(ModifyReplicationGroupRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::snapshotRetentionLimit)).setter(ModifyReplicationGroupRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::snapshotWindow)).setter(ModifyReplicationGroupRequest.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::cacheNodeType)).setter(ModifyReplicationGroupRequest.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::authToken)).setter(ModifyReplicationGroupRequest.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_UPDATE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationGroupRequest.getter(ModifyReplicationGroupRequest::authTokenUpdateStrategyAsString)).setter(ModifyReplicationGroupRequest.setter(Builder::authTokenUpdateStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenUpdateStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, REPLICATION_GROUP_DESCRIPTION_FIELD, PRIMARY_CLUSTER_ID_FIELD, SNAPSHOTTING_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_ENABLED_FIELD, MULTI_AZ_ENABLED_FIELD, NODE_GROUP_ID_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD, NOTIFICATION_TOPIC_STATUS_FIELD, APPLY_IMMEDIATELY_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_FIELD, AUTH_TOKEN_UPDATE_STRATEGY_FIELD));
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String primaryClusterId;
    private final String snapshottingClusterId;
    private final Boolean automaticFailoverEnabled;
    private final Boolean multiAZEnabled;
    private final String nodeGroupId;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final String preferredMaintenanceWindow;
    private final String notificationTopicArn;
    private final String cacheParameterGroupName;
    private final String notificationTopicStatus;
    private final Boolean applyImmediately;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String cacheNodeType;
    private final String authToken;
    private final String authTokenUpdateStrategy;

    private ModifyReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.primaryClusterId = builder.primaryClusterId;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.multiAZEnabled = builder.multiAZEnabled;
        this.nodeGroupId = builder.nodeGroupId;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.applyImmediately = builder.applyImmediately;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.cacheNodeType = builder.cacheNodeType;
        this.authToken = builder.authToken;
        this.authTokenUpdateStrategy = builder.authTokenUpdateStrategy;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public String snapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public Boolean automaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    public Boolean multiAZEnabled() {
        return this.multiAZEnabled;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public boolean hasCacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames != null && !(this.cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String notificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String authToken() {
        return this.authToken;
    }

    public AuthTokenUpdateStrategyType authTokenUpdateStrategy() {
        return AuthTokenUpdateStrategyType.fromValue(this.authTokenUpdateStrategy);
    }

    public String authTokenUpdateStrategyAsString() {
        return this.authTokenUpdateStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshottingClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenUpdateStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupRequest)) {
            return false;
        }
        ModifyReplicationGroupRequest other = (ModifyReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupDescription(), other.replicationGroupDescription()) && Objects.equals(this.primaryClusterId(), other.primaryClusterId()) && Objects.equals(this.snapshottingClusterId(), other.snapshottingClusterId()) && Objects.equals(this.automaticFailoverEnabled(), other.automaticFailoverEnabled()) && Objects.equals(this.multiAZEnabled(), other.multiAZEnabled()) && Objects.equals(this.nodeGroupId(), other.nodeGroupId()) && Objects.equals(this.cacheSecurityGroupNames(), other.cacheSecurityGroupNames()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.notificationTopicArn(), other.notificationTopicArn()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.notificationTopicStatus(), other.notificationTopicStatus()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.authToken(), other.authToken()) && Objects.equals(this.authTokenUpdateStrategyAsString(), other.authTokenUpdateStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"ModifyReplicationGroupRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ReplicationGroupDescription", (Object)this.replicationGroupDescription()).add("PrimaryClusterId", (Object)this.primaryClusterId()).add("SnapshottingClusterId", (Object)this.snapshottingClusterId()).add("AutomaticFailoverEnabled", (Object)this.automaticFailoverEnabled()).add("MultiAZEnabled", (Object)this.multiAZEnabled()).add("NodeGroupId", (Object)this.nodeGroupId()).add("CacheSecurityGroupNames", this.cacheSecurityGroupNames()).add("SecurityGroupIds", this.securityGroupIds()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("NotificationTopicArn", (Object)this.notificationTopicArn()).add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("NotificationTopicStatus", (Object)this.notificationTopicStatus()).add("ApplyImmediately", (Object)this.applyImmediately()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("CacheNodeType", (Object)this.cacheNodeType()).add("AuthToken", (Object)this.authToken()).add("AuthTokenUpdateStrategy", (Object)this.authTokenUpdateStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupDescription()));
            }
            case "PrimaryClusterId": {
                return Optional.ofNullable(clazz.cast(this.primaryClusterId()));
            }
            case "SnapshottingClusterId": {
                return Optional.ofNullable(clazz.cast(this.snapshottingClusterId()));
            }
            case "AutomaticFailoverEnabled": {
                return Optional.ofNullable(clazz.cast(this.automaticFailoverEnabled()));
            }
            case "MultiAZEnabled": {
                return Optional.ofNullable(clazz.cast(this.multiAZEnabled()));
            }
            case "NodeGroupId": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupId()));
            }
            case "CacheSecurityGroupNames": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroupNames()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "NotificationTopicArn": {
                return Optional.ofNullable(clazz.cast(this.notificationTopicArn()));
            }
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "NotificationTopicStatus": {
                return Optional.ofNullable(clazz.cast(this.notificationTopicStatus()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
            case "AuthTokenUpdateStrategy": {
                return Optional.ofNullable(clazz.cast(this.authTokenUpdateStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationGroupRequest, T> g) {
        return obj -> g.apply((ModifyReplicationGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String primaryClusterId;
        private String snapshottingClusterId;
        private Boolean automaticFailoverEnabled;
        private Boolean multiAZEnabled;
        private String nodeGroupId;
        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String preferredMaintenanceWindow;
        private String notificationTopicArn;
        private String cacheParameterGroupName;
        private String notificationTopicStatus;
        private Boolean applyImmediately;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String cacheNodeType;
        private String authToken;
        private String authTokenUpdateStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationGroupRequest model) {
            super(model);
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupDescription(model.replicationGroupDescription);
            this.primaryClusterId(model.primaryClusterId);
            this.snapshottingClusterId(model.snapshottingClusterId);
            this.automaticFailoverEnabled(model.automaticFailoverEnabled);
            this.multiAZEnabled(model.multiAZEnabled);
            this.nodeGroupId(model.nodeGroupId);
            this.cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.securityGroupIds(model.securityGroupIds);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.notificationTopicArn(model.notificationTopicArn);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.notificationTopicStatus(model.notificationTopicStatus);
            this.applyImmediately(model.applyImmediately);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.cacheNodeType(model.cacheNodeType);
            this.authToken(model.authToken);
            this.authTokenUpdateStrategy(model.authTokenUpdateStrategy);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final String getSnapshottingClusterId() {
            return this.snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        public final Boolean getMultiAZEnabled() {
            return this.multiAZEnabled;
        }

        @Override
        public final Builder multiAZEnabled(Boolean multiAZEnabled) {
            this.multiAZEnabled = multiAZEnabled;
            return this;
        }

        public final void setMultiAZEnabled(Boolean multiAZEnabled) {
            this.multiAZEnabled = multiAZEnabled;
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getNotificationTopicStatus() {
            return this.notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public final String getAuthTokenUpdateStrategy() {
            return this.authTokenUpdateStrategy;
        }

        @Override
        public final Builder authTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
            return this;
        }

        @Override
        public final Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy(authTokenUpdateStrategy == null ? null : authTokenUpdateStrategy.toString());
            return this;
        }

        public final void setAuthTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationGroupRequest build() {
            return new ModifyReplicationGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder primaryClusterId(String var1);

        public Builder snapshottingClusterId(String var1);

        public Builder automaticFailoverEnabled(Boolean var1);

        public Builder multiAZEnabled(Boolean var1);

        public Builder nodeGroupId(String var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationTopicArn(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder notificationTopicStatus(String var1);

        public Builder applyImmediately(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder cacheNodeType(String var1);

        public Builder authToken(String var1);

        public Builder authTokenUpdateStrategy(String var1);

        public Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

