/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.RegionalConfiguration;
import software.amazon.awssdk.services.elasticache.model.RegionalConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncreaseNodeGroupsInGlobalReplicationGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, IncreaseNodeGroupsInGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest.getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest::globalReplicationGroupId)).setter(IncreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::globalReplicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build()}).build();
    private static final SdkField<Integer> NODE_GROUP_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest.getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest::nodeGroupCount)).setter(IncreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::nodeGroupCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupCount").build()}).build();
    private static final SdkField<List<RegionalConfiguration>> REGIONAL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest.getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest::regionalConfigurations)).setter(IncreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::regionalConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionalConfigurations").build(), ListTrait.builder().memberLocationName("RegionalConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionalConfiguration").build()}).build()).build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest.getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest::applyImmediately)).setter(IncreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_REPLICATION_GROUP_ID_FIELD, NODE_GROUP_COUNT_FIELD, REGIONAL_CONFIGURATIONS_FIELD, APPLY_IMMEDIATELY_FIELD));
    private final String globalReplicationGroupId;
    private final Integer nodeGroupCount;
    private final List<RegionalConfiguration> regionalConfigurations;
    private final Boolean applyImmediately;

    private IncreaseNodeGroupsInGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.nodeGroupCount = builder.nodeGroupCount;
        this.regionalConfigurations = builder.regionalConfigurations;
        this.applyImmediately = builder.applyImmediately;
    }

    public String globalReplicationGroupId() {
        return this.globalReplicationGroupId;
    }

    public Integer nodeGroupCount() {
        return this.nodeGroupCount;
    }

    public boolean hasRegionalConfigurations() {
        return this.regionalConfigurations != null && !(this.regionalConfigurations instanceof SdkAutoConstructList);
    }

    public List<RegionalConfiguration> regionalConfigurations() {
        return this.regionalConfigurations;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseNodeGroupsInGlobalReplicationGroupRequest)) {
            return false;
        }
        IncreaseNodeGroupsInGlobalReplicationGroupRequest other = (IncreaseNodeGroupsInGlobalReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.globalReplicationGroupId(), other.globalReplicationGroupId()) && Objects.equals(this.nodeGroupCount(), other.nodeGroupCount()) && Objects.equals(this.regionalConfigurations(), other.regionalConfigurations()) && Objects.equals(this.applyImmediately(), other.applyImmediately());
    }

    public String toString() {
        return ToString.builder((String)"IncreaseNodeGroupsInGlobalReplicationGroupRequest").add("GlobalReplicationGroupId", (Object)this.globalReplicationGroupId()).add("NodeGroupCount", (Object)this.nodeGroupCount()).add("RegionalConfigurations", this.regionalConfigurations()).add("ApplyImmediately", (Object)this.applyImmediately()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupId()));
            }
            case "NodeGroupCount": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupCount()));
            }
            case "RegionalConfigurations": {
                return Optional.ofNullable(clazz.cast(this.regionalConfigurations()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncreaseNodeGroupsInGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((IncreaseNodeGroupsInGlobalReplicationGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String globalReplicationGroupId;
        private Integer nodeGroupCount;
        private List<RegionalConfiguration> regionalConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseNodeGroupsInGlobalReplicationGroupRequest model) {
            super(model);
            this.globalReplicationGroupId(model.globalReplicationGroupId);
            this.nodeGroupCount(model.nodeGroupCount);
            this.regionalConfigurations(model.regionalConfigurations);
            this.applyImmediately(model.applyImmediately);
        }

        public final String getGlobalReplicationGroupId() {
            return this.globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        public final Integer getNodeGroupCount() {
            return this.nodeGroupCount;
        }

        @Override
        public final Builder nodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
            return this;
        }

        public final void setNodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
        }

        public final Collection<RegionalConfiguration.Builder> getRegionalConfigurations() {
            return this.regionalConfigurations != null ? (Collection)this.regionalConfigurations.stream().map(RegionalConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regionalConfigurations(Collection<RegionalConfiguration> regionalConfigurations) {
            this.regionalConfigurations = RegionalConfigurationListCopier.copy(regionalConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalConfigurations(RegionalConfiguration ... regionalConfigurations) {
            this.regionalConfigurations(Arrays.asList(regionalConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalConfigurations(Consumer<RegionalConfiguration.Builder> ... regionalConfigurations) {
            this.regionalConfigurations(Stream.of(regionalConfigurations).map(c -> (RegionalConfiguration)((RegionalConfiguration.Builder)RegionalConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegionalConfigurations(Collection<RegionalConfiguration.BuilderImpl> regionalConfigurations) {
            this.regionalConfigurations = RegionalConfigurationListCopier.copyFromBuilder(regionalConfigurations);
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IncreaseNodeGroupsInGlobalReplicationGroupRequest build() {
            return new IncreaseNodeGroupsInGlobalReplicationGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IncreaseNodeGroupsInGlobalReplicationGroupRequest> {
        public Builder globalReplicationGroupId(String var1);

        public Builder nodeGroupCount(Integer var1);

        public Builder regionalConfigurations(Collection<RegionalConfiguration> var1);

        public Builder regionalConfigurations(RegionalConfiguration ... var1);

        public Builder regionalConfigurations(Consumer<RegionalConfiguration.Builder> ... var1);

        public Builder applyImmediately(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

