/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfigurationListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.SnapshotArnsListCopier;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateReplicationGroupRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::replicationGroupId)).setter(CreateReplicationGroupRequest.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::replicationGroupDescription)).setter(CreateReplicationGroupRequest.setter(Builder::replicationGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupDescription").build()}).build();
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::globalReplicationGroupId)).setter(CreateReplicationGroupRequest.setter(Builder::globalReplicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build()}).build();
    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::primaryClusterId)).setter(CreateReplicationGroupRequest.setter(Builder::primaryClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()}).build();
    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::automaticFailoverEnabled)).setter(CreateReplicationGroupRequest.setter(Builder::automaticFailoverEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build()}).build();
    private static final SdkField<Integer> NUM_CACHE_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::numCacheClusters)).setter(CreateReplicationGroupRequest.setter(Builder::numCacheClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheClusters").build()}).build();
    private static final SdkField<List<String>> PREFERRED_CACHE_CLUSTER_A_ZS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::preferredCacheClusterAZs)).setter(CreateReplicationGroupRequest.setter(Builder::preferredCacheClusterAZs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredCacheClusterAZs").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUM_NODE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::numNodeGroups)).setter(CreateReplicationGroupRequest.setter(Builder::numNodeGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumNodeGroups").build()}).build();
    private static final SdkField<Integer> REPLICAS_PER_NODE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::replicasPerNodeGroup)).setter(CreateReplicationGroupRequest.setter(Builder::replicasPerNodeGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicasPerNodeGroup").build()}).build();
    private static final SdkField<List<NodeGroupConfiguration>> NODE_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::nodeGroupConfiguration)).setter(CreateReplicationGroupRequest.setter(Builder::nodeGroupConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupConfiguration").build(), ListTrait.builder().memberLocationName("NodeGroupConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupConfiguration").build()}).build()).build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::cacheNodeType)).setter(CreateReplicationGroupRequest.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::engine)).setter(CreateReplicationGroupRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::engineVersion)).setter(CreateReplicationGroupRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::cacheParameterGroupName)).setter(CreateReplicationGroupRequest.setter(Builder::cacheParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build()}).build();
    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::cacheSubnetGroupName)).setter(CreateReplicationGroupRequest.setter(Builder::cacheSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build()}).build();
    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::cacheSecurityGroupNames)).setter(CreateReplicationGroupRequest.setter(Builder::cacheSecurityGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(), ListTrait.builder().memberLocationName("CacheSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::securityGroupIds)).setter(CreateReplicationGroupRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::tags)).setter(CreateReplicationGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::snapshotArns)).setter(CreateReplicationGroupRequest.setter(Builder::snapshotArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(), ListTrait.builder().memberLocationName("SnapshotArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::snapshotName)).setter(CreateReplicationGroupRequest.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::preferredMaintenanceWindow)).setter(CreateReplicationGroupRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::port)).setter(CreateReplicationGroupRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::notificationTopicArn)).setter(CreateReplicationGroupRequest.setter(Builder::notificationTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::autoMinorVersionUpgrade)).setter(CreateReplicationGroupRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::snapshotRetentionLimit)).setter(CreateReplicationGroupRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::snapshotWindow)).setter(CreateReplicationGroupRequest.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::authToken)).setter(CreateReplicationGroupRequest.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::transitEncryptionEnabled)).setter(CreateReplicationGroupRequest.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::atRestEncryptionEnabled)).setter(CreateReplicationGroupRequest.setter(Builder::atRestEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::kmsKeyId)).setter(CreateReplicationGroupRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, REPLICATION_GROUP_DESCRIPTION_FIELD, GLOBAL_REPLICATION_GROUP_ID_FIELD, PRIMARY_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_ENABLED_FIELD, NUM_CACHE_CLUSTERS_FIELD, PREFERRED_CACHE_CLUSTER_A_ZS_FIELD, NUM_NODE_GROUPS_FIELD, REPLICAS_PER_NODE_GROUP_FIELD, NODE_GROUP_CONFIGURATION_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD, CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PORT_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, AUTH_TOKEN_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, KMS_KEY_ID_FIELD));
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String globalReplicationGroupId;
    private final String primaryClusterId;
    private final Boolean automaticFailoverEnabled;
    private final Integer numCacheClusters;
    private final List<String> preferredCacheClusterAZs;
    private final Integer numNodeGroups;
    private final Integer replicasPerNodeGroup;
    private final List<NodeGroupConfiguration> nodeGroupConfiguration;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final String cacheParameterGroupName;
    private final String cacheSubnetGroupName;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final List<Tag> tags;
    private final List<String> snapshotArns;
    private final String snapshotName;
    private final String preferredMaintenanceWindow;
    private final Integer port;
    private final String notificationTopicArn;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String authToken;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;
    private final String kmsKeyId;

    private CreateReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.numCacheClusters = builder.numCacheClusters;
        this.preferredCacheClusterAZs = builder.preferredCacheClusterAZs;
        this.numNodeGroups = builder.numNodeGroups;
        this.replicasPerNodeGroup = builder.replicasPerNodeGroup;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public String globalReplicationGroupId() {
        return this.globalReplicationGroupId;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public Boolean automaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    public Integer numCacheClusters() {
        return this.numCacheClusters;
    }

    public boolean hasPreferredCacheClusterAZs() {
        return this.preferredCacheClusterAZs != null && !(this.preferredCacheClusterAZs instanceof SdkAutoConstructList);
    }

    public List<String> preferredCacheClusterAZs() {
        return this.preferredCacheClusterAZs;
    }

    public Integer numNodeGroups() {
        return this.numNodeGroups;
    }

    public Integer replicasPerNodeGroup() {
        return this.replicasPerNodeGroup;
    }

    public boolean hasNodeGroupConfiguration() {
        return this.nodeGroupConfiguration != null && !(this.nodeGroupConfiguration instanceof SdkAutoConstructList);
    }

    public List<NodeGroupConfiguration> nodeGroupConfiguration() {
        return this.nodeGroupConfiguration;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public boolean hasCacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames != null && !(this.cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public boolean hasSnapshotArns() {
        return this.snapshotArns != null && !(this.snapshotArns instanceof SdkAutoConstructList);
    }

    public List<String> snapshotArns() {
        return this.snapshotArns;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Integer port() {
        return this.port;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String authToken() {
        return this.authToken;
    }

    public Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheClusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredCacheClusterAZs());
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicasPerNodeGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationGroupRequest)) {
            return false;
        }
        CreateReplicationGroupRequest other = (CreateReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupDescription(), other.replicationGroupDescription()) && Objects.equals(this.globalReplicationGroupId(), other.globalReplicationGroupId()) && Objects.equals(this.primaryClusterId(), other.primaryClusterId()) && Objects.equals(this.automaticFailoverEnabled(), other.automaticFailoverEnabled()) && Objects.equals(this.numCacheClusters(), other.numCacheClusters()) && Objects.equals(this.preferredCacheClusterAZs(), other.preferredCacheClusterAZs()) && Objects.equals(this.numNodeGroups(), other.numNodeGroups()) && Objects.equals(this.replicasPerNodeGroup(), other.replicasPerNodeGroup()) && Objects.equals(this.nodeGroupConfiguration(), other.nodeGroupConfiguration()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && Objects.equals(this.cacheSecurityGroupNames(), other.cacheSecurityGroupNames()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.snapshotArns(), other.snapshotArns()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.notificationTopicArn(), other.notificationTopicArn()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.authToken(), other.authToken()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"CreateReplicationGroupRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ReplicationGroupDescription", (Object)this.replicationGroupDescription()).add("GlobalReplicationGroupId", (Object)this.globalReplicationGroupId()).add("PrimaryClusterId", (Object)this.primaryClusterId()).add("AutomaticFailoverEnabled", (Object)this.automaticFailoverEnabled()).add("NumCacheClusters", (Object)this.numCacheClusters()).add("PreferredCacheClusterAZs", this.preferredCacheClusterAZs()).add("NumNodeGroups", (Object)this.numNodeGroups()).add("ReplicasPerNodeGroup", (Object)this.replicasPerNodeGroup()).add("NodeGroupConfiguration", this.nodeGroupConfiguration()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("CacheSecurityGroupNames", this.cacheSecurityGroupNames()).add("SecurityGroupIds", this.securityGroupIds()).add("Tags", this.tags()).add("SnapshotArns", this.snapshotArns()).add("SnapshotName", (Object)this.snapshotName()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("Port", (Object)this.port()).add("NotificationTopicArn", (Object)this.notificationTopicArn()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("AuthToken", (Object)this.authToken()).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("AtRestEncryptionEnabled", (Object)this.atRestEncryptionEnabled()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupDescription()));
            }
            case "GlobalReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupId()));
            }
            case "PrimaryClusterId": {
                return Optional.ofNullable(clazz.cast(this.primaryClusterId()));
            }
            case "AutomaticFailoverEnabled": {
                return Optional.ofNullable(clazz.cast(this.automaticFailoverEnabled()));
            }
            case "NumCacheClusters": {
                return Optional.ofNullable(clazz.cast(this.numCacheClusters()));
            }
            case "PreferredCacheClusterAZs": {
                return Optional.ofNullable(clazz.cast(this.preferredCacheClusterAZs()));
            }
            case "NumNodeGroups": {
                return Optional.ofNullable(clazz.cast(this.numNodeGroups()));
            }
            case "ReplicasPerNodeGroup": {
                return Optional.ofNullable(clazz.cast(this.replicasPerNodeGroup()));
            }
            case "NodeGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupConfiguration()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "CacheSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheSecurityGroupNames": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroupNames()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SnapshotArns": {
                return Optional.ofNullable(clazz.cast(this.snapshotArns()));
            }
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "NotificationTopicArn": {
                return Optional.ofNullable(clazz.cast(this.notificationTopicArn()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "AtRestEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.atRestEncryptionEnabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationGroupRequest, T> g) {
        return obj -> g.apply((CreateReplicationGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String globalReplicationGroupId;
        private String primaryClusterId;
        private Boolean automaticFailoverEnabled;
        private Integer numCacheClusters;
        private List<String> preferredCacheClusterAZs = DefaultSdkAutoConstructList.getInstance();
        private Integer numNodeGroups;
        private Integer replicasPerNodeGroup;
        private List<NodeGroupConfiguration> nodeGroupConfiguration = DefaultSdkAutoConstructList.getInstance();
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private String cacheParameterGroupName;
        private String cacheSubnetGroupName;
        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();
        private String snapshotName;
        private String preferredMaintenanceWindow;
        private Integer port;
        private String notificationTopicArn;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String authToken;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationGroupRequest model) {
            super(model);
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupDescription(model.replicationGroupDescription);
            this.globalReplicationGroupId(model.globalReplicationGroupId);
            this.primaryClusterId(model.primaryClusterId);
            this.automaticFailoverEnabled(model.automaticFailoverEnabled);
            this.numCacheClusters(model.numCacheClusters);
            this.preferredCacheClusterAZs(model.preferredCacheClusterAZs);
            this.numNodeGroups(model.numNodeGroups);
            this.replicasPerNodeGroup(model.replicasPerNodeGroup);
            this.nodeGroupConfiguration(model.nodeGroupConfiguration);
            this.cacheNodeType(model.cacheNodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.securityGroupIds(model.securityGroupIds);
            this.tags(model.tags);
            this.snapshotArns(model.snapshotArns);
            this.snapshotName(model.snapshotName);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.port(model.port);
            this.notificationTopicArn(model.notificationTopicArn);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.authToken(model.authToken);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getGlobalReplicationGroupId() {
            return this.globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        public final Integer getNumCacheClusters() {
            return this.numCacheClusters;
        }

        @Override
        public final Builder numCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
            return this;
        }

        public final void setNumCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
        }

        public final Collection<String> getPreferredCacheClusterAZs() {
            return this.preferredCacheClusterAZs;
        }

        @Override
        public final Builder preferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredCacheClusterAZs(String ... preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs(Arrays.asList(preferredCacheClusterAZs));
            return this;
        }

        public final void setPreferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
        }

        public final Integer getNumNodeGroups() {
            return this.numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        public final Integer getReplicasPerNodeGroup() {
            return this.replicasPerNodeGroup;
        }

        @Override
        public final Builder replicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
            return this;
        }

        public final void setReplicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
        }

        public final Collection<NodeGroupConfiguration.Builder> getNodeGroupConfiguration() {
            return this.nodeGroupConfiguration != null ? (Collection)this.nodeGroupConfiguration.stream().map(NodeGroupConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copy(nodeGroupConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration ... nodeGroupConfiguration) {
            this.nodeGroupConfiguration(Arrays.asList(nodeGroupConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder> ... nodeGroupConfiguration) {
            this.nodeGroupConfiguration(Stream.of(nodeGroupConfiguration).map(c -> (NodeGroupConfiguration)((NodeGroupConfiguration.Builder)NodeGroupConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeGroupConfiguration(Collection<NodeGroupConfiguration.BuilderImpl> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copyFromBuilder(nodeGroupConfiguration);
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getSnapshotArns() {
            return this.snapshotArns;
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String ... snapshotArns) {
            this.snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationGroupRequest build() {
            return new CreateReplicationGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder globalReplicationGroupId(String var1);

        public Builder primaryClusterId(String var1);

        public Builder automaticFailoverEnabled(Boolean var1);

        public Builder numCacheClusters(Integer var1);

        public Builder preferredCacheClusterAZs(Collection<String> var1);

        public Builder preferredCacheClusterAZs(String ... var1);

        public Builder numNodeGroups(Integer var1);

        public Builder replicasPerNodeGroup(Integer var1);

        public Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> var1);

        public Builder nodeGroupConfiguration(NodeGroupConfiguration ... var1);

        public Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder> ... var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder snapshotArns(Collection<String> var1);

        public Builder snapshotArns(String ... var1);

        public Builder snapshotName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder port(Integer var1);

        public Builder notificationTopicArn(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder authToken(String var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

