/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.ReshardingStatus;
import software.amazon.awssdk.services.elasticache.transform.SlotMigrationUnmarshaller;

public class ReshardingStatusUnmarshaller
implements Unmarshaller<ReshardingStatus, StaxUnmarshallerContext> {
    private static final ReshardingStatusUnmarshaller INSTANCE = new ReshardingStatusUnmarshaller();

    public ReshardingStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReshardingStatus.Builder reshardingStatus = ReshardingStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("SlotMigration", targetDepth)) continue;
                reshardingStatus.slotMigration(SlotMigrationUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReshardingStatus)reshardingStatus.build();
    }

    public static ReshardingStatusUnmarshaller getInstance() {
        return INSTANCE;
    }
}

