/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMember;
import software.amazon.awssdk.services.elasticache.transform.EndpointUnmarshaller;

public class NodeGroupMemberUnmarshaller
implements Unmarshaller<NodeGroupMember, StaxUnmarshallerContext> {
    private static final NodeGroupMemberUnmarshaller INSTANCE = new NodeGroupMemberUnmarshaller();

    public NodeGroupMember unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NodeGroupMember.Builder nodeGroupMember = NodeGroupMember.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheClusterId", targetDepth)) {
                    nodeGroupMember.cacheClusterId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeId", targetDepth)) {
                    nodeGroupMember.cacheNodeId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReadEndpoint", targetDepth)) {
                    nodeGroupMember.readEndpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredAvailabilityZone", targetDepth)) {
                    nodeGroupMember.preferredAvailabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CurrentRole", targetDepth)) continue;
                nodeGroupMember.currentRole(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NodeGroupMember)nodeGroupMember.build();
    }

    public static NodeGroupMemberUnmarshaller getInstance() {
        return INSTANCE;
    }
}

