/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;

public class NodeGroupConfigurationUnmarshaller
implements Unmarshaller<NodeGroupConfiguration, StaxUnmarshallerContext> {
    private static final NodeGroupConfigurationUnmarshaller INSTANCE = new NodeGroupConfigurationUnmarshaller();

    public NodeGroupConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        NodeGroupConfiguration.Builder nodeGroupConfiguration;
        block8: {
            nodeGroupConfiguration = NodeGroupConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> replicaAvailabilityZones = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    nodeGroupConfiguration.replicaAvailabilityZones(replicaAvailabilityZones);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Slots", targetDepth)) {
                        nodeGroupConfiguration.slots(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ReplicaCount", targetDepth)) {
                        nodeGroupConfiguration.replicaCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PrimaryAvailabilityZone", targetDepth)) {
                        nodeGroupConfiguration.primaryAvailabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ReplicaAvailabilityZones", targetDepth)) {
                        replicaAvailabilityZones = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("ReplicaAvailabilityZones/AvailabilityZone", targetDepth)) continue;
                    replicaAvailabilityZones.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            nodeGroupConfiguration.replicaAvailabilityZones(replicaAvailabilityZones);
        }
        return (NodeGroupConfiguration)nodeGroupConfiguration.build();
    }

    public static NodeGroupConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

