/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;

public class DescribeCacheClustersRequestMarshaller
implements Marshaller<Request<DescribeCacheClustersRequest>, DescribeCacheClustersRequest> {
    public Request<DescribeCacheClustersRequest> marshall(DescribeCacheClustersRequest describeCacheClustersRequest) {
        if (describeCacheClustersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeCacheClustersRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheClusters");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheClustersRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)describeCacheClustersRequest.cacheClusterId()));
        }
        if (describeCacheClustersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeCacheClustersRequest.maxRecords()));
        }
        if (describeCacheClustersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeCacheClustersRequest.marker()));
        }
        if (describeCacheClustersRequest.showCacheNodeInfo() != null) {
            request.addParameter("ShowCacheNodeInfo", StringUtils.fromBoolean((Boolean)describeCacheClustersRequest.showCacheNodeInfo()));
        }
        if (describeCacheClustersRequest.showCacheClustersNotInReplicationGroups() != null) {
            request.addParameter("ShowCacheClustersNotInReplicationGroups", StringUtils.fromBoolean((Boolean)describeCacheClustersRequest.showCacheClustersNotInReplicationGroups()));
        }
        return request;
    }
}

