/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup;
import software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup;
import software.amazon.awssdk.services.elasticache.transform.EC2SecurityGroupUnmarshaller;

public class CacheSecurityGroupUnmarshaller
implements Unmarshaller<CacheSecurityGroup, StaxUnmarshallerContext> {
    private static final CacheSecurityGroupUnmarshaller INSTANCE = new CacheSecurityGroupUnmarshaller();

    public CacheSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheSecurityGroup.Builder cacheSecurityGroup;
        block8: {
            cacheSecurityGroup = CacheSecurityGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<EC2SecurityGroup> ec2SecurityGroups = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cacheSecurityGroup.ec2SecurityGroups(ec2SecurityGroups);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("OwnerId", targetDepth)) {
                        cacheSecurityGroup.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CacheSecurityGroupName", targetDepth)) {
                        cacheSecurityGroup.cacheSecurityGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        cacheSecurityGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EC2SecurityGroups", targetDepth)) {
                        ec2SecurityGroups = new ArrayList<EC2SecurityGroup>();
                        continue;
                    }
                    if (!context.testExpression("EC2SecurityGroups/EC2SecurityGroup", targetDepth)) continue;
                    ec2SecurityGroups.add(EC2SecurityGroupUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cacheSecurityGroup.ec2SecurityGroups(ec2SecurityGroups);
        }
        return (CacheSecurityGroup)cacheSecurityGroup.build();
    }

    public static CacheSecurityGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

