/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroup;

public class CacheParameterGroupUnmarshaller
implements Unmarshaller<CacheParameterGroup, StaxUnmarshallerContext> {
    private static final CacheParameterGroupUnmarshaller INSTANCE = new CacheParameterGroupUnmarshaller();

    public CacheParameterGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CacheParameterGroup.Builder cacheParameterGroup = CacheParameterGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheParameterGroupName", targetDepth)) {
                    cacheParameterGroup.cacheParameterGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheParameterGroupFamily", targetDepth)) {
                    cacheParameterGroup.cacheParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Description", targetDepth)) continue;
                cacheParameterGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CacheParameterGroup)cacheParameterGroup.build();
    }

    public static CacheParameterGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

