/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNode;

public final class DescribeReservedCacheNodesPaginator
implements SdkIterable<DescribeReservedCacheNodesResponse> {
    private final ElastiCacheClient client;
    private final DescribeReservedCacheNodesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReservedCacheNodesPaginator(ElastiCacheClient client, DescribeReservedCacheNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedCacheNodesResponseFetcher();
    }

    public Iterator<DescribeReservedCacheNodesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReservedCacheNode> reservedCacheNodes() {
        Function<DescribeReservedCacheNodesResponse, Iterator> getIterator = response -> response != null ? response.reservedCacheNodes().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReservedCacheNodesResponseFetcher
    implements NextPageFetcher<DescribeReservedCacheNodesResponse> {
        private DescribeReservedCacheNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedCacheNodesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedCacheNodesResponse nextPage(DescribeReservedCacheNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedCacheNodesPaginator.this.client.describeReservedCacheNodes(DescribeReservedCacheNodesPaginator.this.firstRequest);
            }
            return DescribeReservedCacheNodesPaginator.this.client.describeReservedCacheNodes((DescribeReservedCacheNodesRequest)((Object)DescribeReservedCacheNodesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

