/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;

public final class DescribeCacheSecurityGroupsPaginator
implements SdkIterable<DescribeCacheSecurityGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheSecurityGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeCacheSecurityGroupsPaginator(ElastiCacheClient client, DescribeCacheSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeCacheSecurityGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CacheSecurityGroup> cacheSecurityGroups() {
        Function<DescribeCacheSecurityGroupsResponse, Iterator> getIterator = response -> response != null ? response.cacheSecurityGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeCacheSecurityGroupsResponseFetcher
    implements NextPageFetcher<DescribeCacheSecurityGroupsResponse> {
        private DescribeCacheSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheSecurityGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheSecurityGroupsResponse nextPage(DescribeCacheSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheSecurityGroupsPaginator.this.client.describeCacheSecurityGroups(DescribeCacheSecurityGroupsPaginator.this.firstRequest);
            }
            return DescribeCacheSecurityGroupsPaginator.this.client.describeCacheSecurityGroups((DescribeCacheSecurityGroupsRequest)((Object)DescribeCacheSecurityGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

