/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersion;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;

public final class DescribeCacheEngineVersionsPaginator
implements SdkIterable<DescribeCacheEngineVersionsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheEngineVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeCacheEngineVersionsPaginator(ElastiCacheClient client, DescribeCacheEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeCacheEngineVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CacheEngineVersion> cacheEngineVersions() {
        Function<DescribeCacheEngineVersionsResponse, Iterator> getIterator = response -> response != null ? response.cacheEngineVersions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeCacheEngineVersionsResponseFetcher
    implements NextPageFetcher<DescribeCacheEngineVersionsResponse> {
        private DescribeCacheEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheEngineVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheEngineVersionsResponse nextPage(DescribeCacheEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheEngineVersionsPaginator.this.client.describeCacheEngineVersions(DescribeCacheEngineVersionsPaginator.this.firstRequest);
            }
            return DescribeCacheEngineVersionsPaginator.this.client.describeCacheEngineVersions((DescribeCacheEngineVersionsRequest)((Object)DescribeCacheEngineVersionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

