/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PendingModifiedValues
implements ToCopyableBuilder<Builder, PendingModifiedValues> {
    private final Integer numCacheNodes;
    private final List<String> cacheNodeIdsToRemove;
    private final String engineVersion;
    private final String cacheNodeType;

    private PendingModifiedValues(BuilderImpl builder) {
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeIdsToRemove = builder.cacheNodeIdsToRemove;
        this.engineVersion = builder.engineVersion;
        this.cacheNodeType = builder.cacheNodeType;
    }

    public Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public List<String> cacheNodeIdsToRemove() {
        return this.cacheNodeIdsToRemove;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeIdsToRemove());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues)obj;
        return Objects.equals(this.numCacheNodes(), other.numCacheNodes()) && Objects.equals(this.cacheNodeIdsToRemove(), other.cacheNodeIdsToRemove()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType());
    }

    public String toString() {
        return ToString.builder((String)"PendingModifiedValues").add("NumCacheNodes", (Object)this.numCacheNodes()).add("CacheNodeIdsToRemove", this.cacheNodeIdsToRemove()).add("EngineVersion", (Object)this.engineVersion()).add("CacheNodeType", (Object)this.cacheNodeType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumCacheNodes": {
                return Optional.of(clazz.cast(this.numCacheNodes()));
            }
            case "CacheNodeIdsToRemove": {
                return Optional.of(clazz.cast(this.cacheNodeIdsToRemove()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "CacheNodeType": {
                return Optional.of(clazz.cast(this.cacheNodeType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numCacheNodes;
        private List<String> cacheNodeIdsToRemove;
        private String engineVersion;
        private String cacheNodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            this.numCacheNodes(model.numCacheNodes);
            this.cacheNodeIdsToRemove(model.cacheNodeIdsToRemove);
            this.engineVersion(model.engineVersion);
            this.cacheNodeType(model.cacheNodeType);
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final Collection<String> getCacheNodeIdsToRemove() {
            return this.cacheNodeIdsToRemove;
        }

        @Override
        public final Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove(Arrays.asList(cacheNodeIdsToRemove));
            return this;
        }

        public final void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PendingModifiedValues> {
        public Builder numCacheNodes(Integer var1);

        public Builder cacheNodeIdsToRemove(Collection<String> var1);

        public Builder cacheNodeIdsToRemove(String ... var1);

        public Builder engineVersion(String var1);

        public Builder cacheNodeType(String var1);
    }
}

