/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersion;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersionListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheEngineVersionsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheEngineVersionsResponse> {
    private final String marker;
    private final List<CacheEngineVersion> cacheEngineVersions;

    private DescribeCacheEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheEngineVersions = builder.cacheEngineVersions;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheEngineVersion> cacheEngineVersions() {
        return this.cacheEngineVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheEngineVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheEngineVersionsResponse)) {
            return false;
        }
        DescribeCacheEngineVersionsResponse other = (DescribeCacheEngineVersionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.cacheEngineVersions(), other.cacheEngineVersions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCacheEngineVersionsResponse").add("Marker", (Object)this.marker()).add("CacheEngineVersions", this.cacheEngineVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "CacheEngineVersions": {
                return Optional.of(clazz.cast(this.cacheEngineVersions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheEngineVersion> cacheEngineVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheEngineVersionsResponse model) {
            this.marker(model.marker);
            this.cacheEngineVersions(model.cacheEngineVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheEngineVersion.Builder> getCacheEngineVersions() {
            return this.cacheEngineVersions != null ? (Collection)this.cacheEngineVersions.stream().map(CacheEngineVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheEngineVersions(Collection<CacheEngineVersion> cacheEngineVersions) {
            this.cacheEngineVersions = CacheEngineVersionListCopier.copy(cacheEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheEngineVersions(CacheEngineVersion ... cacheEngineVersions) {
            this.cacheEngineVersions(Arrays.asList(cacheEngineVersions));
            return this;
        }

        public final void setCacheEngineVersions(Collection<CacheEngineVersion.BuilderImpl> cacheEngineVersions) {
            this.cacheEngineVersions = CacheEngineVersionListCopier.copyFromBuilder(cacheEngineVersions);
        }

        @Override
        public DescribeCacheEngineVersionsResponse build() {
            return new DescribeCacheEngineVersionsResponse(this);
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    CopyableBuilder<Builder, DescribeCacheEngineVersionsResponse> {
        public Builder marker(String var1);

        public Builder cacheEngineVersions(Collection<CacheEngineVersion> var1);

        public Builder cacheEngineVersions(CacheEngineVersion ... var1);
    }
}

