/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.Subnet;
import software.amazon.awssdk.services.elasticache.transform.AvailabilityZoneUnmarshaller;

public class SubnetUnmarshaller
implements Unmarshaller<Subnet, StaxUnmarshallerContext> {
    private static SubnetUnmarshaller INSTANCE;

    public Subnet unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Subnet.Builder subnet = Subnet.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SubnetIdentifier", targetDepth)) {
                    subnet.subnetIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SubnetAvailabilityZone", targetDepth)) continue;
                subnet.subnetAvailabilityZone(AvailabilityZoneUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Subnet)subnet.build();
    }

    public static SubnetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SubnetUnmarshaller();
        }
        return INSTANCE;
    }
}

