/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.NodeSnapshot;
import software.amazon.awssdk.services.elasticache.transform.NodeGroupConfigurationUnmarshaller;

public class NodeSnapshotUnmarshaller
implements Unmarshaller<NodeSnapshot, StaxUnmarshallerContext> {
    private static NodeSnapshotUnmarshaller INSTANCE;

    public NodeSnapshot unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NodeSnapshot.Builder nodeSnapshot = NodeSnapshot.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheClusterId", targetDepth)) {
                    nodeSnapshot.cacheClusterId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeGroupId", targetDepth)) {
                    nodeSnapshot.nodeGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeId", targetDepth)) {
                    nodeSnapshot.cacheNodeId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeGroupConfiguration", targetDepth)) {
                    nodeSnapshot.nodeGroupConfiguration(NodeGroupConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheSize", targetDepth)) {
                    nodeSnapshot.cacheSize(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeCreateTime", targetDepth)) {
                    nodeSnapshot.cacheNodeCreateTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SnapshotCreateTime", targetDepth)) continue;
                nodeSnapshot.snapshotCreateTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NodeSnapshot)nodeSnapshot.build();
    }

    public static NodeSnapshotUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NodeSnapshotUnmarshaller();
        }
        return INSTANCE;
    }
}

