/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheSecurityGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCacheSecurityGroupsResponse> {
    private final String marker;
    private final List<CacheSecurityGroup> cacheSecurityGroups;

    private DescribeCacheSecurityGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.cacheSecurityGroups = builder.cacheSecurityGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheSecurityGroup> cacheSecurityGroups() {
        return this.cacheSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.cacheSecurityGroups() == null ? 0 : this.cacheSecurityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheSecurityGroupsResponse)) {
            return false;
        }
        DescribeCacheSecurityGroupsResponse other = (DescribeCacheSecurityGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.cacheSecurityGroups() == null ^ this.cacheSecurityGroups() == null) {
            return false;
        }
        return other.cacheSecurityGroups() == null || other.cacheSecurityGroups().equals(this.cacheSecurityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.cacheSecurityGroups() != null) {
            sb.append("CacheSecurityGroups: ").append(this.cacheSecurityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheSecurityGroup> cacheSecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheSecurityGroupsResponse model) {
            this.setMarker(model.marker);
            this.setCacheSecurityGroups(model.cacheSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheSecurityGroup> getCacheSecurityGroups() {
            return this.cacheSecurityGroups;
        }

        @Override
        public final Builder cacheSecurityGroups(Collection<CacheSecurityGroup> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupsCopier.copy(cacheSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(CacheSecurityGroup ... cacheSecurityGroups) {
            this.cacheSecurityGroups(Arrays.asList(cacheSecurityGroups));
            return this;
        }

        public final void setCacheSecurityGroups(Collection<CacheSecurityGroup> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupsCopier.copy(cacheSecurityGroups);
        }

        @SafeVarargs
        public final void setCacheSecurityGroups(CacheSecurityGroup ... cacheSecurityGroups) {
            this.cacheSecurityGroups(Arrays.asList(cacheSecurityGroups));
        }

        public DescribeCacheSecurityGroupsResponse build() {
            return new DescribeCacheSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCacheSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheSecurityGroups(Collection<CacheSecurityGroup> var1);

        public Builder cacheSecurityGroups(CacheSecurityGroup ... var1);
    }
}

