/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersion;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheEngineVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCacheEngineVersionsResponse> {
    private final String marker;
    private final List<CacheEngineVersion> cacheEngineVersions;

    private DescribeCacheEngineVersionsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.cacheEngineVersions = builder.cacheEngineVersions;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheEngineVersion> cacheEngineVersions() {
        return this.cacheEngineVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.cacheEngineVersions() == null ? 0 : this.cacheEngineVersions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheEngineVersionsResponse)) {
            return false;
        }
        DescribeCacheEngineVersionsResponse other = (DescribeCacheEngineVersionsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.cacheEngineVersions() == null ^ this.cacheEngineVersions() == null) {
            return false;
        }
        return other.cacheEngineVersions() == null || other.cacheEngineVersions().equals(this.cacheEngineVersions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.cacheEngineVersions() != null) {
            sb.append("CacheEngineVersions: ").append(this.cacheEngineVersions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheEngineVersion> cacheEngineVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheEngineVersionsResponse model) {
            this.setMarker(model.marker);
            this.setCacheEngineVersions(model.cacheEngineVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheEngineVersion> getCacheEngineVersions() {
            return this.cacheEngineVersions;
        }

        @Override
        public final Builder cacheEngineVersions(Collection<CacheEngineVersion> cacheEngineVersions) {
            this.cacheEngineVersions = CacheEngineVersionListCopier.copy(cacheEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheEngineVersions(CacheEngineVersion ... cacheEngineVersions) {
            this.cacheEngineVersions(Arrays.asList(cacheEngineVersions));
            return this;
        }

        public final void setCacheEngineVersions(Collection<CacheEngineVersion> cacheEngineVersions) {
            this.cacheEngineVersions = CacheEngineVersionListCopier.copy(cacheEngineVersions);
        }

        @SafeVarargs
        public final void setCacheEngineVersions(CacheEngineVersion ... cacheEngineVersions) {
            this.cacheEngineVersions(Arrays.asList(cacheEngineVersions));
        }

        public DescribeCacheEngineVersionsResponse build() {
            return new DescribeCacheEngineVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCacheEngineVersionsResponse> {
        public Builder marker(String var1);

        public Builder cacheEngineVersions(Collection<CacheEngineVersion> var1);

        public Builder cacheEngineVersions(CacheEngineVersion ... var1);
    }
}

