/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.ConfigureShard;

public class ConfigureShardUnmarshaller
implements Unmarshaller<ConfigureShard, StaxUnmarshallerContext> {
    private static final ConfigureShardUnmarshaller INSTANCE = new ConfigureShardUnmarshaller();

    public ConfigureShard unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConfigureShard.Builder configureShard;
        block7: {
            configureShard = ConfigureShard.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> preferredAvailabilityZones = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    configureShard.preferredAvailabilityZones(preferredAvailabilityZones);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("NodeGroupId", targetDepth)) {
                        configureShard.nodeGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NewReplicaCount", targetDepth)) {
                        configureShard.newReplicaCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PreferredAvailabilityZones", targetDepth)) {
                        preferredAvailabilityZones = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("PreferredAvailabilityZones/PreferredAvailabilityZone", targetDepth)) continue;
                    preferredAvailabilityZones.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            configureShard.preferredAvailabilityZones(preferredAvailabilityZones);
        }
        return (ConfigureShard)configureShard.build();
    }

    public static ConfigureShardUnmarshaller getInstance() {
        return INSTANCE;
    }
}

