/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;

public class DescribeCacheSubnetGroupsIterable
implements SdkIterable<DescribeCacheSubnetGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheSubnetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCacheSubnetGroupsIterable(ElastiCacheClient client, DescribeCacheSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeCacheSubnetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CacheSubnetGroup> cacheSubnetGroups() {
        Function<DescribeCacheSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheSubnetGroups() != null) {
                return response.cacheSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeCacheSubnetGroupsIterable resume(DescribeCacheSubnetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheSubnetGroupsIterable(this.client, (DescribeCacheSubnetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheSubnetGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeCacheSubnetGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeCacheSubnetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeCacheSubnetGroupsResponse> {
        private DescribeCacheSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeCacheSubnetGroupsResponse nextPage(DescribeCacheSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheSubnetGroupsIterable.this.client.describeCacheSubnetGroups(DescribeCacheSubnetGroupsIterable.this.firstRequest);
            }
            return DescribeCacheSubnetGroupsIterable.this.client.describeCacheSubnetGroups((DescribeCacheSubnetGroupsRequest)((Object)DescribeCacheSubnetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

