/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse;

public class DescribeCacheParameterGroupsPublisher
implements SdkPublisher<DescribeCacheParameterGroupsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheParameterGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheParameterGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheParameterGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheParameterGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheParameterGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheParameterGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheParameterGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CacheParameterGroup> cacheParameterGroups() {
        Function<DescribeCacheParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheParameterGroups() != null) {
                return response.cacheParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCacheParameterGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeCacheParameterGroupsPublisher resume(DescribeCacheParameterGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheParameterGroupsPublisher(this.client, (DescribeCacheParameterGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheParameterGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeCacheParameterGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeCacheParameterGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeCacheParameterGroupsResponse> {
        private DescribeCacheParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCacheParameterGroupsResponse> nextPage(DescribeCacheParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheParameterGroupsPublisher.this.client.describeCacheParameterGroups(DescribeCacheParameterGroupsPublisher.this.firstRequest);
            }
            return DescribeCacheParameterGroupsPublisher.this.client.describeCacheParameterGroups((DescribeCacheParameterGroupsRequest)((Object)DescribeCacheParameterGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

