/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest;

public class RebootCacheClusterRequestMarshaller
implements Marshaller<Request<RebootCacheClusterRequest>, RebootCacheClusterRequest> {
    public Request<RebootCacheClusterRequest> marshall(RebootCacheClusterRequest rebootCacheClusterRequest) {
        if (rebootCacheClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)rebootCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "RebootCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebootCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringConversion.fromString((String)rebootCacheClusterRequest.cacheClusterId()));
        }
        if (rebootCacheClusterRequest.cacheNodeIdsToReboot().isEmpty() && !(rebootCacheClusterRequest.cacheNodeIdsToReboot() instanceof SdkAutoConstructList)) {
            request.addParameter("CacheNodeIdsToReboot", "");
        } else if (!rebootCacheClusterRequest.cacheNodeIdsToReboot().isEmpty() && !(rebootCacheClusterRequest.cacheNodeIdsToReboot() instanceof SdkAutoConstructList)) {
            List<String> cacheNodeIdsToRebootList = rebootCacheClusterRequest.cacheNodeIdsToReboot();
            int cacheNodeIdsToRebootListIndex = 1;
            for (String cacheNodeIdsToRebootListValue : cacheNodeIdsToRebootList) {
                if (cacheNodeIdsToRebootListValue != null) {
                    request.addParameter("CacheNodeIdsToReboot.CacheNodeId." + cacheNodeIdsToRebootListIndex, StringConversion.fromString((String)cacheNodeIdsToRebootListValue));
                }
                ++cacheNodeIdsToRebootListIndex;
            }
        }
        return request;
    }
}

