/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest;

public class DeleteSnapshotRequestMarshaller
implements Marshaller<Request<DeleteSnapshotRequest>, DeleteSnapshotRequest> {
    public Request<DeleteSnapshotRequest> marshall(DeleteSnapshotRequest deleteSnapshotRequest) {
        if (deleteSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteSnapshotRequest, "ElastiCacheClient");
        request.addParameter("Action", "DeleteSnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSnapshotRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringConversion.fromString((String)deleteSnapshotRequest.snapshotName()));
        }
        return request;
    }
}

