/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;

public class DescribeCacheSecurityGroupsIterable
implements SdkIterable<DescribeCacheSecurityGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheSecurityGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCacheSecurityGroupsIterable(ElastiCacheClient client, DescribeCacheSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeCacheSecurityGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CacheSecurityGroup> cacheSecurityGroups() {
        Function<DescribeCacheSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheSecurityGroups() != null) {
                return response.cacheSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeCacheSecurityGroupsIterable resume(DescribeCacheSecurityGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheSecurityGroupsIterable(this.client, (DescribeCacheSecurityGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheSecurityGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeCacheSecurityGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeCacheSecurityGroupsResponseFetcher
    implements SyncPageFetcher<DescribeCacheSecurityGroupsResponse> {
        private DescribeCacheSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheSecurityGroupsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeCacheSecurityGroupsResponse nextPage(DescribeCacheSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheSecurityGroupsIterable.this.client.describeCacheSecurityGroups(DescribeCacheSecurityGroupsIterable.this.firstRequest);
            }
            return DescribeCacheSecurityGroupsIterable.this.client.describeCacheSecurityGroups((DescribeCacheSecurityGroupsRequest)((Object)DescribeCacheSecurityGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

