/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParametersListCopier;
import software.amazon.awssdk.services.elasticache.model.Parameter;
import software.amazon.awssdk.services.elasticache.model.ParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineDefaults
implements ToCopyableBuilder<Builder, EngineDefaults> {
    private final String cacheParameterGroupFamily;
    private final String marker;
    private final List<Parameter> parameters;
    private final List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters;

    private EngineDefaults(BuilderImpl builder) {
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.marker = builder.marker;
        this.parameters = builder.parameters;
        this.cacheNodeTypeSpecificParameters = builder.cacheNodeTypeSpecificParameters;
    }

    public String cacheParameterGroupFamily() {
        return this.cacheParameterGroupFamily;
    }

    public String marker() {
        return this.marker;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters() {
        return this.cacheNodeTypeSpecificParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeTypeSpecificParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineDefaults)) {
            return false;
        }
        EngineDefaults other = (EngineDefaults)obj;
        return Objects.equals(this.cacheParameterGroupFamily(), other.cacheParameterGroupFamily()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.cacheNodeTypeSpecificParameters(), other.cacheNodeTypeSpecificParameters());
    }

    public String toString() {
        return ToString.builder((String)"EngineDefaults").add("CacheParameterGroupFamily", (Object)this.cacheParameterGroupFamily()).add("Marker", (Object)this.marker()).add("Parameters", this.parameters()).add("CacheNodeTypeSpecificParameters", this.cacheNodeTypeSpecificParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupFamily()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "CacheNodeTypeSpecificParameters": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeTypeSpecificParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheParameterGroupFamily;
        private String marker;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngineDefaults model) {
            this.cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            this.marker(model.marker);
            this.parameters(model.parameters);
            this.cacheNodeTypeSpecificParameters(model.cacheNodeTypeSpecificParameters);
        }

        public final String getCacheParameterGroupFamily() {
            return this.cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        public final Collection<CacheNodeTypeSpecificParameter.Builder> getCacheNodeTypeSpecificParameters() {
            return this.cacheNodeTypeSpecificParameters != null ? (Collection)this.cacheNodeTypeSpecificParameters.stream().map(CacheNodeTypeSpecificParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters = CacheNodeTypeSpecificParametersListCopier.copy(cacheNodeTypeSpecificParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter ... cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters(Arrays.asList(cacheNodeTypeSpecificParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificParameters(Consumer<CacheNodeTypeSpecificParameter.Builder> ... cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters(Stream.of(cacheNodeTypeSpecificParameters).map(c -> (CacheNodeTypeSpecificParameter)((CacheNodeTypeSpecificParameter.Builder)CacheNodeTypeSpecificParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter.BuilderImpl> cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters = CacheNodeTypeSpecificParametersListCopier.copyFromBuilder(cacheNodeTypeSpecificParameters);
        }

        public EngineDefaults build() {
            return new EngineDefaults(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EngineDefaults> {
        public Builder cacheParameterGroupFamily(String var1);

        public Builder marker(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder cacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> var1);

        public Builder cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter ... var1);

        public Builder cacheNodeTypeSpecificParameters(Consumer<CacheNodeTypeSpecificParameter.Builder> ... var1);
    }
}

