/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.SlotMigration;

public class SlotMigrationUnmarshaller
implements Unmarshaller<SlotMigration, StaxUnmarshallerContext> {
    private static final SlotMigrationUnmarshaller INSTANCE = new SlotMigrationUnmarshaller();

    public SlotMigration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SlotMigration.Builder slotMigration = SlotMigration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("ProgressPercentage", targetDepth)) continue;
                slotMigration.progressPercentage(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SlotMigration)slotMigration.build();
    }

    public static SlotMigrationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

