/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest;

public class DeleteCacheClusterRequestMarshaller
implements Marshaller<Request<DeleteCacheClusterRequest>, DeleteCacheClusterRequest> {
    public Request<DeleteCacheClusterRequest> marshall(DeleteCacheClusterRequest deleteCacheClusterRequest) {
        if (deleteCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "DeleteCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)deleteCacheClusterRequest.cacheClusterId()));
        }
        if (deleteCacheClusterRequest.finalSnapshotIdentifier() != null) {
            request.addParameter("FinalSnapshotIdentifier", StringUtils.fromString((String)deleteCacheClusterRequest.finalSnapshotIdentifier()));
        }
        return request;
    }
}

