/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup;
import software.amazon.awssdk.services.elasticache.model.Subnet;
import software.amazon.awssdk.services.elasticache.transform.SubnetUnmarshaller;

public class CacheSubnetGroupUnmarshaller
implements Unmarshaller<CacheSubnetGroup, StaxUnmarshallerContext> {
    private static final CacheSubnetGroupUnmarshaller INSTANCE = new CacheSubnetGroupUnmarshaller();

    public CacheSubnetGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheSubnetGroup.Builder cacheSubnetGroup;
        block8: {
            cacheSubnetGroup = CacheSubnetGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<Subnet> subnets = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cacheSubnetGroup.subnets(subnets);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("CacheSubnetGroupName", targetDepth)) {
                        cacheSubnetGroup.cacheSubnetGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CacheSubnetGroupDescription", targetDepth)) {
                        cacheSubnetGroup.cacheSubnetGroupDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcId", targetDepth)) {
                        cacheSubnetGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Subnets", targetDepth)) {
                        subnets = new ArrayList<Subnet>();
                        continue;
                    }
                    if (!context.testExpression("Subnets/Subnet", targetDepth)) continue;
                    subnets.add(SubnetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cacheSubnetGroup.subnets(subnets);
        }
        return (CacheSubnetGroup)cacheSubnetGroup.build();
    }

    public static CacheSubnetGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

