/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.elasticache.model.Parameter;

public class DescribeEngineDefaultParametersPublisher
implements SdkPublisher<DescribeEngineDefaultParametersResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeEngineDefaultParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEngineDefaultParametersPublisher(ElastiCacheAsyncClient client, DescribeEngineDefaultParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEngineDefaultParametersPublisher(ElastiCacheAsyncClient client, DescribeEngineDefaultParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEngineDefaultParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEngineDefaultParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Parameter> parameters() {
        Function<DescribeEngineDefaultParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.engineDefaults() != null && response.engineDefaults().parameters() != null) {
                return response.engineDefaults().parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeEngineDefaultParametersResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeEngineDefaultParametersPublisher resume(DescribeEngineDefaultParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEngineDefaultParametersPublisher(this.client, (DescribeEngineDefaultParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.engineDefaults().marker()).build()));
        }
        return new DescribeEngineDefaultParametersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeEngineDefaultParametersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeEngineDefaultParametersResponseFetcher
    implements AsyncPageFetcher<DescribeEngineDefaultParametersResponse> {
        private DescribeEngineDefaultParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEngineDefaultParametersResponse previousPage) {
            return previousPage.engineDefaults().marker() != null;
        }

        public CompletableFuture<DescribeEngineDefaultParametersResponse> nextPage(DescribeEngineDefaultParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeEngineDefaultParametersPublisher.this.client.describeEngineDefaultParameters(DescribeEngineDefaultParametersPublisher.this.firstRequest);
            }
            return DescribeEngineDefaultParametersPublisher.this.client.describeEngineDefaultParameters((DescribeEngineDefaultParametersRequest)((Object)DescribeEngineDefaultParametersPublisher.this.firstRequest.toBuilder().marker(previousPage.engineDefaults().marker()).build()));
        }
    }
}

