/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;

public class DescribeCacheSubnetGroupsPublisher
implements SdkPublisher<DescribeCacheSubnetGroupsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheSubnetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheSubnetGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheSubnetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheSubnetGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheSubnetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheSubnetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheSubnetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<CacheSubnetGroup> cacheSubnetGroups() {
        Function<DescribeCacheSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheSubnetGroups() != null) {
                return response.cacheSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeCacheSubnetGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeCacheSubnetGroupsPublisher resume(DescribeCacheSubnetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheSubnetGroupsPublisher(this.client, (DescribeCacheSubnetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheSubnetGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeCacheSubnetGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeCacheSubnetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeCacheSubnetGroupsResponse> {
        private DescribeCacheSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeCacheSubnetGroupsResponse> nextPage(DescribeCacheSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheSubnetGroupsPublisher.this.client.describeCacheSubnetGroups(DescribeCacheSubnetGroupsPublisher.this.firstRequest);
            }
            return DescribeCacheSubnetGroupsPublisher.this.client.describeCacheSubnetGroups((DescribeCacheSubnetGroupsRequest)((Object)DescribeCacheSubnetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

