/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.Parameter;

public class DescribeCacheParametersIterable
implements SdkIterable<DescribeCacheParametersResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCacheParametersIterable(ElastiCacheClient client, DescribeCacheParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheParametersResponseFetcher();
    }

    public Iterator<DescribeCacheParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeCacheParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeCacheParametersIterable resume(DescribeCacheParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheParametersIterable(this.client, (DescribeCacheParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheParametersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeCacheParametersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeCacheParametersResponseFetcher
    implements SyncPageFetcher<DescribeCacheParametersResponse> {
        private DescribeCacheParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheParametersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheParametersResponse nextPage(DescribeCacheParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheParametersIterable.this.client.describeCacheParameters(DescribeCacheParametersIterable.this.firstRequest);
            }
            return DescribeCacheParametersIterable.this.client.describeCacheParameters((DescribeCacheParametersRequest)((Object)DescribeCacheParametersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

