/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersion;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;

public class DescribeCacheEngineVersionsIterable
implements SdkIterable<DescribeCacheEngineVersionsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCacheEngineVersionsIterable(ElastiCacheClient client, DescribeCacheEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCacheEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeCacheEngineVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<CacheEngineVersion> cacheEngineVersions() {
        Function<DescribeCacheEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheEngineVersions() != null) {
                return response.cacheEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeCacheEngineVersionsIterable resume(DescribeCacheEngineVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheEngineVersionsIterable(this.client, (DescribeCacheEngineVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheEngineVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeCacheEngineVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeCacheEngineVersionsResponseFetcher
    implements SyncPageFetcher<DescribeCacheEngineVersionsResponse> {
        private DescribeCacheEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheEngineVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeCacheEngineVersionsResponse nextPage(DescribeCacheEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheEngineVersionsIterable.this.client.describeCacheEngineVersions(DescribeCacheEngineVersionsIterable.this.firstRequest);
            }
            return DescribeCacheEngineVersionsIterable.this.client.describeCacheEngineVersions((DescribeCacheEngineVersionsRequest)((Object)DescribeCacheEngineVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

