/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMember;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMemberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NodeGroup
implements ToCopyableBuilder<Builder, NodeGroup> {
    private final String nodeGroupId;
    private final String status;
    private final Endpoint primaryEndpoint;
    private final String slots;
    private final List<NodeGroupMember> nodeGroupMembers;

    private NodeGroup(BuilderImpl builder) {
        this.nodeGroupId = builder.nodeGroupId;
        this.status = builder.status;
        this.primaryEndpoint = builder.primaryEndpoint;
        this.slots = builder.slots;
        this.nodeGroupMembers = builder.nodeGroupMembers;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public String status() {
        return this.status;
    }

    public Endpoint primaryEndpoint() {
        return this.primaryEndpoint;
    }

    public String slots() {
        return this.slots;
    }

    public List<NodeGroupMember> nodeGroupMembers() {
        return this.nodeGroupMembers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupMembers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroup)) {
            return false;
        }
        NodeGroup other = (NodeGroup)obj;
        return Objects.equals(this.nodeGroupId(), other.nodeGroupId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.primaryEndpoint(), other.primaryEndpoint()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.nodeGroupMembers(), other.nodeGroupMembers());
    }

    public String toString() {
        return ToString.builder((String)"NodeGroup").add("NodeGroupId", (Object)this.nodeGroupId()).add("Status", (Object)this.status()).add("PrimaryEndpoint", (Object)this.primaryEndpoint()).add("Slots", (Object)this.slots()).add("NodeGroupMembers", this.nodeGroupMembers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeGroupId": {
                return Optional.of(clazz.cast(this.nodeGroupId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "PrimaryEndpoint": {
                return Optional.of(clazz.cast(this.primaryEndpoint()));
            }
            case "Slots": {
                return Optional.of(clazz.cast(this.slots()));
            }
            case "NodeGroupMembers": {
                return Optional.of(clazz.cast(this.nodeGroupMembers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeGroupId;
        private String status;
        private Endpoint primaryEndpoint;
        private String slots;
        private List<NodeGroupMember> nodeGroupMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroup model) {
            this.nodeGroupId(model.nodeGroupId);
            this.status(model.status);
            this.primaryEndpoint(model.primaryEndpoint);
            this.slots(model.slots);
            this.nodeGroupMembers(model.nodeGroupMembers);
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Endpoint.Builder getPrimaryEndpoint() {
            return this.primaryEndpoint != null ? this.primaryEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder primaryEndpoint(Endpoint primaryEndpoint) {
            this.primaryEndpoint = primaryEndpoint;
            return this;
        }

        public final void setPrimaryEndpoint(Endpoint.BuilderImpl primaryEndpoint) {
            this.primaryEndpoint = primaryEndpoint != null ? primaryEndpoint.build() : null;
        }

        public final String getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final Collection<NodeGroupMember.Builder> getNodeGroupMembers() {
            return this.nodeGroupMembers != null ? (Collection)this.nodeGroupMembers.stream().map(NodeGroupMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroupMembers(Collection<NodeGroupMember> nodeGroupMembers) {
            this.nodeGroupMembers = NodeGroupMemberListCopier.copy(nodeGroupMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupMembers(NodeGroupMember ... nodeGroupMembers) {
            this.nodeGroupMembers(Arrays.asList(nodeGroupMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupMembers(Consumer<NodeGroupMember.Builder> ... nodeGroupMembers) {
            this.nodeGroupMembers(Stream.of(nodeGroupMembers).map(c -> (NodeGroupMember)((NodeGroupMember.Builder)NodeGroupMember.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeGroupMembers(Collection<NodeGroupMember.BuilderImpl> nodeGroupMembers) {
            this.nodeGroupMembers = NodeGroupMemberListCopier.copyFromBuilder(nodeGroupMembers);
        }

        public NodeGroup build() {
            return new NodeGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NodeGroup> {
        public Builder nodeGroupId(String var1);

        public Builder status(String var1);

        public Builder primaryEndpoint(Endpoint var1);

        default public Builder primaryEndpoint(Consumer<Endpoint.Builder> primaryEndpoint) {
            return this.primaryEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().apply(primaryEndpoint)).build());
        }

        public Builder slots(String var1);

        public Builder nodeGroupMembers(Collection<NodeGroupMember> var1);

        public Builder nodeGroupMembers(NodeGroupMember ... var1);

        public Builder nodeGroupMembers(Consumer<NodeGroupMember.Builder> ... var1);
    }
}

