/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroup;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReplicationGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
    private final String marker;
    private final List<ReplicationGroup> replicationGroups;

    private DescribeReplicationGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationGroups = builder.replicationGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReplicationGroup> replicationGroups() {
        return this.replicationGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationGroupsResponse)) {
            return false;
        }
        DescribeReplicationGroupsResponse other = (DescribeReplicationGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.replicationGroups(), other.replicationGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationGroupsResponse").add("Marker", (Object)this.marker()).add("ReplicationGroups", this.replicationGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ReplicationGroups": {
                return Optional.of(clazz.cast(this.replicationGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationGroup> replicationGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationGroups(model.replicationGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationGroup.Builder> getReplicationGroups() {
            return this.replicationGroups != null ? (Collection)this.replicationGroups.stream().map(ReplicationGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationGroups(Collection<ReplicationGroup> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copy(replicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(ReplicationGroup ... replicationGroups) {
            this.replicationGroups(Arrays.asList(replicationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(Consumer<ReplicationGroup.Builder> ... replicationGroups) {
            this.replicationGroups(Stream.of(replicationGroups).map(c -> (ReplicationGroup)((ReplicationGroup.Builder)ReplicationGroup.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationGroups(Collection<ReplicationGroup.BuilderImpl> replicationGroups) {
            this.replicationGroups = ReplicationGroupListCopier.copyFromBuilder(replicationGroups);
        }

        @Override
        public DescribeReplicationGroupsResponse build() {
            return new DescribeReplicationGroupsResponse(this);
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    CopyableBuilder<Builder, DescribeReplicationGroupsResponse> {
        public Builder marker(String var1);

        public Builder replicationGroups(Collection<ReplicationGroup> var1);

        public Builder replicationGroups(ReplicationGroup ... var1);

        public Builder replicationGroups(Consumer<ReplicationGroup.Builder> ... var1);
    }
}

