/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.RecurringCharge;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNode;
import software.amazon.awssdk.services.elasticache.transform.RecurringChargeUnmarshaller;

public class ReservedCacheNodeUnmarshaller
implements Unmarshaller<ReservedCacheNode, StaxUnmarshallerContext> {
    private static ReservedCacheNodeUnmarshaller INSTANCE;

    public ReservedCacheNode unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReservedCacheNode.Builder reservedCacheNode = ReservedCacheNode.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ReservedCacheNodeId", targetDepth)) {
                    reservedCacheNode.reservedCacheNodeId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReservedCacheNodesOfferingId", targetDepth)) {
                    reservedCacheNode.reservedCacheNodesOfferingId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeType", targetDepth)) {
                    reservedCacheNode.cacheNodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StartTime", targetDepth)) {
                    reservedCacheNode.startTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Duration", targetDepth)) {
                    reservedCacheNode.duration(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FixedPrice", targetDepth)) {
                    reservedCacheNode.fixedPrice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UsagePrice", targetDepth)) {
                    reservedCacheNode.usagePrice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeCount", targetDepth)) {
                    reservedCacheNode.cacheNodeCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProductDescription", targetDepth)) {
                    reservedCacheNode.productDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OfferingType", targetDepth)) {
                    reservedCacheNode.offeringType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("State", targetDepth)) {
                    reservedCacheNode.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RecurringCharges", targetDepth)) {
                    reservedCacheNode.recurringCharges(new ArrayList<RecurringCharge>());
                    continue;
                }
                if (!context.testExpression("RecurringCharges/RecurringCharge", targetDepth)) continue;
                reservedCacheNode.recurringCharges(RecurringChargeUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReservedCacheNode)reservedCacheNode.build();
    }

    public static ReservedCacheNodeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReservedCacheNodeUnmarshaller();
        }
        return INSTANCE;
    }
}

