/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.PendingModifiedValues;

public class PendingModifiedValuesUnmarshaller
implements Unmarshaller<PendingModifiedValues, StaxUnmarshallerContext> {
    private static PendingModifiedValuesUnmarshaller INSTANCE;

    public PendingModifiedValues unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PendingModifiedValues.Builder pendingModifiedValues = PendingModifiedValues.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NumCacheNodes", targetDepth)) {
                    pendingModifiedValues.numCacheNodes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeIdsToRemove", targetDepth)) {
                    pendingModifiedValues.cacheNodeIdsToRemove(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("CacheNodeIdsToRemove/CacheNodeId", targetDepth)) {
                    pendingModifiedValues.cacheNodeIdsToRemove(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    pendingModifiedValues.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CacheNodeType", targetDepth)) continue;
                pendingModifiedValues.cacheNodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PendingModifiedValues)pendingModifiedValues.build();
    }

    public static PendingModifiedValuesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PendingModifiedValuesUnmarshaller();
        }
        return INSTANCE;
    }
}

