/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.NodeGroup;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMember;
import software.amazon.awssdk.services.elasticache.transform.EndpointUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.NodeGroupMemberUnmarshaller;

public class NodeGroupUnmarshaller
implements Unmarshaller<NodeGroup, StaxUnmarshallerContext> {
    private static NodeGroupUnmarshaller INSTANCE;

    public NodeGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NodeGroup.Builder nodeGroup = NodeGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NodeGroupId", targetDepth)) {
                    nodeGroup.nodeGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    nodeGroup.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PrimaryEndpoint", targetDepth)) {
                    nodeGroup.primaryEndpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Slots", targetDepth)) {
                    nodeGroup.slots(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeGroupMembers", targetDepth)) {
                    nodeGroup.nodeGroupMembers(new ArrayList<NodeGroupMember>());
                    continue;
                }
                if (!context.testExpression("NodeGroupMembers/NodeGroupMember", targetDepth)) continue;
                nodeGroup.nodeGroupMembers(NodeGroupMemberUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NodeGroup)nodeGroup.build();
    }

    public static NodeGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NodeGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

