/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;

public class NodeGroupConfigurationUnmarshaller
implements Unmarshaller<NodeGroupConfiguration, StaxUnmarshallerContext> {
    private static NodeGroupConfigurationUnmarshaller INSTANCE;

    public NodeGroupConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NodeGroupConfiguration.Builder nodeGroupConfiguration = NodeGroupConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Slots", targetDepth)) {
                    nodeGroupConfiguration.slots(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicaCount", targetDepth)) {
                    nodeGroupConfiguration.replicaCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PrimaryAvailabilityZone", targetDepth)) {
                    nodeGroupConfiguration.primaryAvailabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicaAvailabilityZones", targetDepth)) {
                    nodeGroupConfiguration.replicaAvailabilityZones(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("ReplicaAvailabilityZones/AvailabilityZone", targetDepth)) continue;
                nodeGroupConfiguration.replicaAvailabilityZones(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NodeGroupConfiguration)nodeGroupConfiguration.build();
    }

    public static NodeGroupConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NodeGroupConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

