/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValue;
import software.amazon.awssdk.util.StringUtils;

public class ModifyCacheParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyCacheParameterGroupRequest>, ModifyCacheParameterGroupRequest> {
    public Request<ModifyCacheParameterGroupRequest> marshall(ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) {
        SdkInternalList parameterNameValuesList;
        if (modifyCacheParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyCacheParameterGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheParameterGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)modifyCacheParameterGroupRequest.cacheParameterGroupName()));
        }
        if (!(parameterNameValuesList = (SdkInternalList)modifyCacheParameterGroupRequest.parameterNameValues()).isEmpty() || !parameterNameValuesList.isAutoConstruct()) {
            int parameterNameValuesListIndex = 1;
            for (ParameterNameValue parameterNameValuesListValue : parameterNameValuesList) {
                if (parameterNameValuesListValue.parameterName() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterName", StringUtils.fromString((String)parameterNameValuesListValue.parameterName()));
                }
                if (parameterNameValuesListValue.parameterValue() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterValue", StringUtils.fromString((String)parameterNameValuesListValue.parameterValue()));
                }
                ++parameterNameValuesListIndex;
            }
        }
        return request;
    }
}

