/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyCacheClusterRequestMarshaller
implements Marshaller<Request<ModifyCacheClusterRequest>, ModifyCacheClusterRequest> {
    public Request<ModifyCacheClusterRequest> marshall(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        SdkInternalList securityGroupIdsList;
        SdkInternalList cacheSecurityGroupNamesList;
        SdkInternalList newAvailabilityZonesList;
        SdkInternalList cacheNodeIdsToRemoveList;
        if (modifyCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)modifyCacheClusterRequest.cacheClusterId()));
        }
        if (modifyCacheClusterRequest.numCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringUtils.fromInteger((Integer)modifyCacheClusterRequest.numCacheNodes()));
        }
        if (!(cacheNodeIdsToRemoveList = (SdkInternalList)modifyCacheClusterRequest.cacheNodeIdsToRemove()).isEmpty() || !cacheNodeIdsToRemoveList.isAutoConstruct()) {
            int cacheNodeIdsToRemoveListIndex = 1;
            for (Object cacheNodeIdsToRemoveListValue : cacheNodeIdsToRemoveList) {
                if (cacheNodeIdsToRemoveListValue != null) {
                    request.addParameter("CacheNodeIdsToRemove.CacheNodeId." + cacheNodeIdsToRemoveListIndex, StringUtils.fromString((String)cacheNodeIdsToRemoveListValue));
                }
                ++cacheNodeIdsToRemoveListIndex;
            }
        }
        if (modifyCacheClusterRequest.azMode() != null) {
            request.addParameter("AZMode", StringUtils.fromString((String)modifyCacheClusterRequest.azMode()));
        }
        if (!(newAvailabilityZonesList = (SdkInternalList)modifyCacheClusterRequest.newAvailabilityZones()).isEmpty() || !newAvailabilityZonesList.isAutoConstruct()) {
            int newAvailabilityZonesListIndex = 1;
            for (Object newAvailabilityZonesListValue : newAvailabilityZonesList) {
                if (newAvailabilityZonesListValue != null) {
                    request.addParameter("NewAvailabilityZones.PreferredAvailabilityZone." + newAvailabilityZonesListIndex, StringUtils.fromString((String)newAvailabilityZonesListValue));
                }
                ++newAvailabilityZonesListIndex;
            }
        }
        if (!(cacheSecurityGroupNamesList = (SdkInternalList)modifyCacheClusterRequest.cacheSecurityGroupNames()).isEmpty() || !cacheSecurityGroupNamesList.isAutoConstruct()) {
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (!(securityGroupIdsList = (SdkInternalList)modifyCacheClusterRequest.securityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyCacheClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyCacheClusterRequest.preferredMaintenanceWindow()));
        }
        if (modifyCacheClusterRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)modifyCacheClusterRequest.notificationTopicArn()));
        }
        if (modifyCacheClusterRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)modifyCacheClusterRequest.cacheParameterGroupName()));
        }
        if (modifyCacheClusterRequest.notificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringUtils.fromString((String)modifyCacheClusterRequest.notificationTopicStatus()));
        }
        if (modifyCacheClusterRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyCacheClusterRequest.applyImmediately()));
        }
        if (modifyCacheClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyCacheClusterRequest.engineVersion()));
        }
        if (modifyCacheClusterRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyCacheClusterRequest.autoMinorVersionUpgrade()));
        }
        if (modifyCacheClusterRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)modifyCacheClusterRequest.snapshotRetentionLimit()));
        }
        if (modifyCacheClusterRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)modifyCacheClusterRequest.snapshotWindow()));
        }
        if (modifyCacheClusterRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)modifyCacheClusterRequest.cacheNodeType()));
        }
        return request;
    }
}

