/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        if (describeSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotsRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSnapshotsRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)describeSnapshotsRequest.replicationGroupId()));
        }
        if (describeSnapshotsRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)describeSnapshotsRequest.cacheClusterId()));
        }
        if (describeSnapshotsRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)describeSnapshotsRequest.snapshotName()));
        }
        if (describeSnapshotsRequest.snapshotSource() != null) {
            request.addParameter("SnapshotSource", StringUtils.fromString((String)describeSnapshotsRequest.snapshotSource()));
        }
        if (describeSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeSnapshotsRequest.marker()));
        }
        if (describeSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeSnapshotsRequest.maxRecords()));
        }
        if (describeSnapshotsRequest.showNodeGroupConfig() != null) {
            request.addParameter("ShowNodeGroupConfig", StringUtils.fromBoolean((Boolean)describeSnapshotsRequest.showNodeGroupConfig()));
        }
        return request;
    }
}

