/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteCacheClusterRequestMarshaller
implements Marshaller<Request<DeleteCacheClusterRequest>, DeleteCacheClusterRequest> {
    public Request<DeleteCacheClusterRequest> marshall(DeleteCacheClusterRequest deleteCacheClusterRequest) {
        if (deleteCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "DeleteCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)deleteCacheClusterRequest.cacheClusterId()));
        }
        if (deleteCacheClusterRequest.finalSnapshotIdentifier() != null) {
            request.addParameter("FinalSnapshotIdentifier", StringUtils.fromString((String)deleteCacheClusterRequest.finalSnapshotIdentifier()));
        }
        return request;
    }
}

